% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwic_method.R
\docType{methods}
\name{kwic}
\alias{kwic}
\alias{kwic,character-method}
\alias{kwic,context-method}
\alias{kwic,partition-method}
\title{KWIC output / concordances}
\usage{
kwic(.Object, ...)

\S4method{kwic}{context}(.Object, meta = getOption("polmineR.meta"),
  cpos = TRUE, neighbor = NULL, verbose = FALSE)

\S4method{kwic}{partition}(.Object, query, cqp = is.cqp,
  left = getOption("polmineR.left"), right = getOption("polmineR.right"),
  meta = getOption("polmineR.meta"), pAttribute = "word",
  sAttribute = NULL, cpos = TRUE, neighbor = NULL, verbose = TRUE)

\S4method{kwic}{character}(.Object, query, cqp = is.cqp,
  left = getOption("polmineR.left"), right = getOption("polmineR.right"),
  meta = getOption("polmineR.meta"), pAttribute = "word",
  sAttribute = NULL, cpos = TRUE, neighbor = NULL, verbose = TRUE)
}
\arguments{
\item{.Object}{a \code{partition} or \code{context} object}

\item{...}{further parameters to be passed}

\item{meta}{metainformation to display}

\item{cpos}{logical}

\item{neighbor}{only show kwic if a certain word is present}

\item{verbose}{logical, whether to be talkative}

\item{query}{a query, CQP-syntax can be used}

\item{cqp}{either logical (TRUE if query is a CQP query), or a
function to check whether query is a CQP query or not (defaults to is.query
auxiliary function)}

\item{left}{to the left}

\item{right}{to the right}

\item{pAttribute}{typically 'word' or 'lemma'}

\item{sAttribute}{if provided, the s-attribute will be used to check the boundaries of the text}
}
\description{
Prepare and show concordances / keyword-in-context (kwic). The same result can be achieved by 
applying the kwich method on either a partition or a context object.
}
\examples{
\dontrun{
if (require(polmineR.sampleCorpus) && require(rcqp)){
  use("polmineR.sampleCorpus")
  bt <- partition("PLPRBTTXT", def=list(text_date=".*"), regex=TRUE)
  kwic(bt, "Integration")
  kwic(
    bt, "Integration",
    left=20, right=20,
    meta=c("text_date", "text_name", "text_party")
  )
  kwic(
    bt, '"Integration" [] "(Menschen|Migrant.*|Personen)"',
    left=20, right=20,
    meta=c("text_date", "text_name", "text_party")
  ) 
}
}
}
\seealso{
To read the whole text, see the \code{\link{read}}-method.
}

