% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/bundle.R
\docType{class}
\name{bundle-class}
\alias{bundle-class}
\alias{bundle}
\alias{name<-,bundle,character-method}
\alias{length,bundle-method}
\alias{names,bundle-method}
\alias{names<-,bundle,vector-method}
\alias{unique,bundle-method}
\alias{+,bundle,bundle-method}
\alias{+,bundle,textstat-method}
\alias{[[,bundle-method}
\alias{[[<-,bundle-method}
\alias{$,bundle-method}
\alias{$<-,bundle-method}
\alias{sample,bundle-method}
\alias{as.bundle,list-method}
\alias{as.bundle,textstat-method}
\alias{as.data.table.bundle}
\alias{as.matrix,bundle-method}
\alias{subset,bundle-method}
\alias{as.list,bundle-method}
\title{Bundle Class}
\usage{
\S4method{name}{bundle,character}(x) <- value

\S4method{length}{bundle}(x)

\S4method{names}{bundle}(x)

\S4method{names}{bundle,vector}(x) <- value

\S4method{unique}{bundle}(x)

\S4method{+}{bundle,bundle}(e1, e2)

\S4method{+}{bundle,textstat}(e1, e2)

\S4method{[[}{bundle}(x, i)

\S4method{[[}{bundle}(x, i) <- value

\S4method{$}{bundle}(x, name)

\S4method{$}{bundle}(x, name) <- value

\S4method{sample}{bundle}(x, size)

\S4method{as.bundle}{list}(object, ...)

\S4method{as.bundle}{textstat}(object)

\method{as.data.table}{bundle}(x, col)

\S4method{as.matrix}{bundle}(x, col)

\S4method{subset}{bundle}(x, ...)

\S4method{as.list}{bundle}(x)
}
\arguments{
\item{x}{a bundle object}

\item{value}{character string with a name to be assigned}

\item{e1}{object 1}

\item{e2}{object 2}

\item{i}{integer to index a bundle object}

\item{name}{The name of an object in the \code{bundle} object.}

\item{size}{number of items to choose to generate a sample}

\item{object}{a bundle object}

\item{...}{further parameters}

\item{col}{columns of the data.table to use to generate an object}
}
\description{
A \code{bundle} is used to combine several objects (\code{partition}, \code{context},
\code{features}, \code{cooccurrences} objects) into one S4 class object. Typically,
a class inheriting from the \code{bundle} superclass will be used. When working with a
\code{context_bundle}, a \code{features_bundle}, a \code{cooccurrences_bundle}, or a
\code{context_bundle}, a similar set of standard methods is available to perform 
transformations.
}
\section{Slots}{

\describe{
\item{\code{corpus}}{The CWB corpus the objects in the \code{bundle} are based on, a length 1 
\code{character} vector.}

\item{\code{objects}}{An object of class \code{"list"}}

\item{\code{p_attribute}}{Object of class \code{"character"}}

\item{\code{encoding}}{The encoding of the corpus.}
}}

\examples{
parties <- s_attributes("GERMAPARLMINI", "party")
parties <- parties[-which(parties == "NA")]
party_bundle <- partition_bundle("GERMAPARLMINI", s_attribute = "party")
length(party_bundle)
names(party_bundle)
party_bundle <- enrich(party_bundle, p_attribute = "word")
summary(party_bundle)
parties_big <- party_bundle[[c("CDU_CSU", "SPD")]]
summary(parties_big)
p <- partition("GERMAPARLMINI", date = "2009-11-11")
pb <- partition_bundle(p, s_attribute = "party")
names(pb)
pb[["NA"]] <- NULL
names(pb)
pb <- partition_bundle("GERMAPARLMINI", s_attribute = "party")
pb$SPD # access partition names "SPD" in partition_bundle pb
pb <- partition_bundle("GERMAPARLMINI", s_attribute = "party")
pb$"NA" <- NULL # quotation needed if name is "NA"
use("polmineR")
Ps <- partition_bundle(
  "REUTERS", s_attribute = "id",
  values = s_attributes("REUTERS", "id")
)
Cs <- cooccurrences(Ps, query = "oil", cqp = FALSE, verbose = FALSE, progress = TRUE)
dt <- polmineR:::as.data.table.bundle(Cs, col = "ll")
m <- as.matrix(Cs, col = "ll")
}
\author{
Andreas Blaette
}
