% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{encodings}
\alias{encodings}
\alias{as.utf8}
\alias{as.nativeEnc}
\alias{as.corpusEnc}
\title{Conversion between corpus and native encoding.}
\usage{
as.utf8(x, from)

as.nativeEnc(x, from)

as.corpusEnc(x, from = encoding(), corpusEnc)
}
\arguments{
\item{x}{A \code{character} to be converted.}

\item{from}{A \code{character} vector describing the encoding of the input
character vector.}

\item{corpusEnc}{A \code{character} vector describing the target encoding,
i.e. the encoding of the corpus (usually "latin1", "UTF-8")}
}
\description{
Utility functions to convert the encoding of a \code{character} vector
between the native encoding and the encoding of the corpus.
}
\details{
The encoding of a corpus and the encoding of the terminal (the native
encoding) may differ, provoking strange or wrong results if no conversion is
carried out between the potentially differing encodings. The functions
\code{as.nativeEnc()} and \code{as.corpusEnc} are auxiliary functions to
assist the conversion. The functions \code{as.nativeEnc} and \code{as.utf8}
deliberately remove the explicit statement of the encoding, to avoid warnings
that may occur with character vector columns in a \code{data.table} object.
}
