% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R, R/objfun.R
\docType{methods}
\name{simulate}
\alias{simulate}
\alias{simulate,missing-method}
\alias{simulate,data.frame-method}
\alias{simulate,pomp-method}
\alias{simulate,objfun-method}
\title{Simulations of a partially-observed Markov process}
\usage{
\S4method{simulate}{missing}(
  nsim = 1,
  seed = NULL,
  times,
  t0,
  params,
  rinit,
  rprocess,
  rmeasure,
  format = c("pomps", "arrays", "data.frame"),
  include.data = FALSE,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{simulate}{data.frame}(
  object,
  nsim = 1,
  seed = NULL,
  times,
  t0,
  params,
  rinit,
  rprocess,
  rmeasure,
  format = c("pomps", "arrays", "data.frame"),
  include.data = FALSE,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{simulate}{pomp}(
  object,
  nsim = 1,
  seed = NULL,
  format = c("pomps", "arrays", "data.frame"),
  include.data = FALSE,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{simulate}{objfun}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{nsim}{The number of simulations to perform.
Note that the number of replicates will be \code{nsim} times \code{ncol(params)}.}

\item{seed}{optional;
if set, the pseudorandom number generator (RNG) will be initialized with \code{seed}.  the random seed to use.
The RNG will be restored to its original state afterward.}

\item{times}{the sequence of observation times.
\code{times} must indicate the column of observation times by name or index.
The time vector must be numeric and non-decreasing.}

\item{t0}{The zero-time, i.e., the time of the initial state.
This must be no later than the time of the first observation, i.e., \code{t0 <= times[1]}.}

\item{params}{a named numeric vector or a matrix with rownames
containing the parameters at which the simulations are to be performed.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{rinit specification}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, see \link[=rprocess_spec]{rprocess specification for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure_spec]{rmeasure specification}.}

\item{format}{the format in which to return the results.

\code{format = "pomps"} causes the results to be returned as a single \dQuote{pomp} object,
identical to \code{object} except for the latent states and observations,
which have been replaced by the simulated values.

\code{format = "arrays"} causes the results to be returned as a list of two arrays.
The \dQuote{states} element will contain the simulated state trajectories in a rank-3 array with dimensions
\code{nvar} x \code{(ncol(params)*nsim)} x \code{ntimes}.
Here, \code{nvar} is the number of state variables and \code{ntimes} the length of the argument \code{times}.
The \dQuote{obs} element will contain the simulated data, returned as a rank-3 array with dimensions
\code{nobs} x \code{(ncol(params)*nsim)} x \code{ntimes}.
Here, \code{nobs} is the number of observables.

\code{format = "data.frame"} causes the results to be returned as a single data frame containing
the time, states, and observations.
An ordered factor variable, \sQuote{.id}, distinguishes one simulation from another.}

\item{include.data}{if \code{TRUE}, the original data and covariates (if any) are included (with \code{.id = "data"}).
This option is ignored unless \code{format = "data.frame"}.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}

\item{object}{optional;
if present, it should be a data frame or a \sQuote{pomp} object.}
}
\value{
A single \dQuote{pomp} object,
a \dQuote{pompList} object,
a named list of two arrays,
or a data frame, according to the \code{format} option.

If \code{params} is a matrix, each column is treated as a distinct parameter set.
In this case, if \code{nsim=1},
then \code{simulate} will return one simulation for each parameter set.
If \code{nsim>1},
then \code{simulate} will yield \code{nsim} simulations for each parameter set.
These will be ordered such that
the first \code{ncol(params)} simulations represent one simulation
from each of the distinct parameter sets,
the second \code{ncol(params)} simulations represent a second simulation from each,
and so on.

Adding column names to \code{params} can be helpful.
}
\description{
\code{simulate} generates simulations of the state and measurement
processes.
}
\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\seealso{
More on \pkg{pomp} elementary algorithms: 
\code{\link{elementary_algorithms}},
\code{\link{kalman}},
\code{\link{pfilter}()},
\code{\link{pomp-package}},
\code{\link{probe}()},
\code{\link{spect}()},
\code{\link{trajectory}()},
\code{\link{wpfilter}()}
}
\author{
Aaron A. King
}
\concept{elementary algorithms}
