% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impulse_response.R
\name{iRAM_equilibrium}
\alias{iRAM_equilibrium}
\title{Generate iRAM (impulse response anlaysis metric) in the equilibrium form.}
\usage{
iRAM_equilibrium(beta.matrix, var.number, lag.order)
}
\arguments{
\item{beta.matrix}{beta matrix for a point estimate}

\item{var.number}{number of variables in the time series}

\item{lag.order}{lag order of the model to be fit}
}
\value{
a list of equilibria. First numeric number in the variable name indicate  where the impulse was given, and the second numeric number indicate the response, e.g., e12 indicates equilibrium of node 2 when node 1 is given an impulse.
}
\description{
Generate iRAM (impulse response anlaysis metric) in the equilibrium form.
}
\examples{
\dontshow{
iRAM_evalue <- iRAM_equilibrium(beta.matrix = true_beta_3node,
    var.number = 3,
    lag.order = 1
    )
iRAM_evalue
}
\donttest{
iRAM_evalue <- iRAM_equilibrium(beta.matrix = true_beta_3node,
    var.number = 3,
    lag.order = 1
    )
iRAM_evalue
}


}
