% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{poststat}
\alias{poststat}
\title{Calculate point estimates from the posterior distribution}
\usage{
poststat(posterior, limits, method, wtreg = NULL)
}
\arguments{
\item{posterior}{is a matrix or a vector with samples from the posterior
distribution obtained from ABC parameter estimation. If this input is a
matrix, then each row should correspond to an accepted simulation (size S)
and each column to a different parameter.}

\item{limits}{is a vector if there is only one parameter or a matrix if there
are multiple parameters. In this latter instance, each row should
correspond to a different parameter. In either instance, and considering
matrix rows as vectors, then the first entry of the vector should be the
minimum value of the prior and the second entry should be the maximum value
(for any given parameter).}

\item{method}{either "rejection" or "regression" indicating whether a
rejection sampling algorithm or a local linear regression algorithm were
used during ABC parameter estimation.}

\item{wtreg}{is a required numeric vector if the method is "regression". It
should contain the weights for each accepted simulation (size S).}
}
\value{
a matrix with the mode, median and mean of the posterior distribution
for each parameter. Each point estimate is a different row and each
parameter a different column.
}
\description{
Given a set of samples from the posterior distribution, computes the mean,
median and mode of the posterior.
}
\details{
If \code{method} is "regression", the regression weights must also be made
available. These will be used to compute the weighted mean, weighted median
and weighted mode of the posterior.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)
# load the matrix with the prior limits
data(limits)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]
# we should remove the random simulation from the sumstats and params matrices
sumstats <- sumstats[-10, ]; params <- params[-10, ]

# parameter estimation for a single target
myabc <- singleABC(target = target, params = params, sumstats = sumstats,
limits = limits, tol = 0.01, method = "regression")

# compute point estimates from the posterior distribution
poststat(posterior = myabc$adjusted, limits = limits, method = "regression", wtreg = myabc$wt)

}
