% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genobaypass2pooldata.R
\name{genobaypass2pooldata}
\alias{genobaypass2pooldata}
\title{Convert BayPass read count and haploid pool size input files into a pooldata object}
\usage{
genobaypass2pooldata(
  genobaypass.file = "",
  poolsize.file = "",
  poolnames = NA,
  min.cov.per.pool = -1,
  max.cov.per.pool = 1e+06,
  min.maf = -1,
  nlines.per.readblock = 1e+06
)
}
\arguments{
\item{genobaypass.file}{The name (or a path) of the BayPass read count file (see the BayPass manual \url{http://www1.montpellier.inra.fr/CBGP/software/baypass/})}

\item{poolsize.file}{The name (or a path) of the BayPass (haploid) pool size file (see the BayPass manual \url{http://www1.montpellier.inra.fr/CBGP/software/baypass/})}

\item{poolnames}{A character vector with the names of pool}

\item{min.cov.per.pool}{Minimal allowed read count (per pool). If at least one pool is not covered by at least min.cov.perpool reads, the position is discarded}

\item{max.cov.per.pool}{Maximal allowed read count (per pool). If at least one pool is covered by more than min.cov.perpool reads, the position is discarded}

\item{min.maf}{Minimal allowed Minor Allele Frequency (computed from the ratio overal read counts for the reference allele over the read coverage)}

\item{nlines.per.readblock}{Number of Lines read simultaneously. Should be adapted to the available RAM.}
}
\value{
A pooldata object containing 7 elements:
\enumerate{
\item "refallele.readcount": a matrix with nsnp rows and npools columns containing read counts for the reference allele (chosen arbitrarily) in each pool
\item "readcoverage": a matrix with nsnp rows and npools columns containing read coverage in each pool
\item "snp.info": a matrix with nsnp rows and four columns containing respectively the contig (or chromosome) name (1st column) and position (2nd column) of the SNP; the allele in the reference assembly (3rd column); the allele taken as reference in the refallele matrix.readcount matrix (4th column); and the alternative allele (5th column)
\item "poolsizes": a vector of length npools containing the haploid pool sizes
\item "poolnames": a vector of length npools containing the names of the pools
\item "nsnp": a scalar corresponding to the number of SNPs
\item "npools": a scalar corresponding to the number of pools
}
}
\description{
Convert BayPass read count and haploid pool size input files into a pooldata object
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 pooldata2genobaypass(pooldata=pooldata,writing.dir=tempdir())
 pooldata=genobaypass2pooldata(genobaypass.file=paste0(tempdir(),"/genobaypass"),
                               poolsize.file=paste0(tempdir(),"/poolsize"))
}
