% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_logreg_xerrors2.R
\name{p_logreg_xerrors2}
\alias{p_logreg_xerrors2}
\title{Poolwise Logistic Regression with Gamma Exposure Subject to Errors}
\usage{
p_logreg_xerrors2(g = NULL, y, xtilde, c = NULL,
  errors = "processing", nondiff_pe = TRUE, nondiff_me = TRUE,
  constant_pe = TRUE, prev = NULL, samp_y1y0 = NULL,
  estimate_var = TRUE, start_nonvar_var = c(0.01, 1),
  lower_nonvar_var = c(-Inf, 1e-04), upper_nonvar_var = c(Inf, Inf),
  jitter_start = 0.01, hcubature_list = list(tol = 1e-08),
  nlminb_list = list(control = list(trace = 1, eval.max = 500, iter.max =
  500)), hessian_list = list(method.args = list(r = 4)),
  nlminb_object = NULL)
}
\arguments{
\item{g}{Numeric vector with pool sizes, i.e. number of members in each pool.}

\item{y}{Numeric vector with poolwise Y values, coded 0 if all members are
controls and 1 if all members are cases.}

\item{xtilde}{Numeric vector (or list of numeric vectors, if some pools have
replicates) with Xtilde values.}

\item{c}{List where each element is a numeric matrix containing the
\strong{C} values for members of a particular pool (1 row for each member).}

\item{errors}{Character string specifying the errors that X is subject to.
Choices are \code{"neither"}, \code{"processing"} for processing error
only, \code{"measurement"} for measurement error only, and \code{"both"}.}

\item{nondiff_pe}{Logical value for whether to assume the processing error
variance is non-differential, i.e. the same in case pools and control pools.}

\item{nondiff_me}{Logical value for whether to assume the measurement error
variance is non-differential, i.e. the same in case pools and control pools.}

\item{constant_pe}{Logical value for whether to assume the processing error
variance is constant with pool size. If \code{FALSE}, assumption is that
processing error variance increase with pool size such that, for example, the
processing error affecting a pool 2x as large as another has 2x the variance.}

\item{prev}{Numeric value specifying disease prevalence, allowing
for valid estimation of the intercept with case-control sampling. Can specify
\code{samp_y1y0} instead if sampling rates are known.}

\item{samp_y1y0}{Numeric vector of length 2 specifying sampling probabilities
for cases and controls, allowing for valid estimation of the intercept with
case-control sampling. Can specify \code{prev} instead if it's easier.}

\item{estimate_var}{Logical value for whether to return variance-covariance
matrix for parameter estimates.}

\item{start_nonvar_var}{Numeric vector of length 2 specifying starting value
for non-variance terms and variance terms, respectively.}

\item{lower_nonvar_var}{Numeric vector of length 2 specifying lower bound for
non-variance terms and variance terms, respectively.}

\item{upper_nonvar_var}{Numeric vector of length 2 specifying upper bound for
non-variance terms and variance terms, respectively.}

\item{jitter_start}{Numeric value specifying standard deviation for mean-0
normal jitters to add to starting values for a second try at maximizing the
log-likelihood, should the initial call to \code{\link[stats]{nlminb}} result
in non-convergence. Set to \code{NULL} for no second try.}

\item{hcubature_list}{List of arguments to pass to
\code{\link[cubature]{hcubature}} for numerical integration.}

\item{nlminb_list}{List of arguments to pass to \code{\link[stats]{nlminb}}
for log-likelihood maximization.}

\item{hessian_list}{List of arguments to pass to
\code{\link[numDeriv]{hessian}} for approximating the Hessian matrix. Only
used if \code{estimate_var = TRUE}.}

\item{nlminb_object}{Object returned from \code{\link[stats]{nlminb}} in a
prior call. Useful for bypassing log-likelihood maximization if you just want
to re-estimate the Hessian matrix with different options.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
Assumes constant-scale Gamma model for exposure given covariates, and
multiplicative lognormal processing errors and measurement errors acting on
the poolwise mean exposure. Manuscript fully describing the approach is
under review.
}
\examples{
# Load dataset with (g, Y, Xtilde, C) values for 248 pools and list of C
# values for members of each pool. Xtilde values are affected by processing
# error.
data(pdat2)
dat <- pdat2$dat
c.list <- pdat2$c.list

# Estimate log-OR for X and Y adjusted for C, ignoring processing error
fit1 <- p_logreg_xerrors2(
  g = dat$g,
  y = dat$y,
  xtilde = dat$xtilde,
  c = c.list,
  errors = "neither"
)
fit1$theta.hat

# Repeat, but accounting for processing error.
\dontrun{
fit2 <- p_logreg_xerrors2(
  g = dat$g,
  y = dat$y,
  xtilde = dat$xtilde,
  c = c.list,
  errors = "processing"
)
fit2$theta.hat
}


}
\references{
Mitchell, E.M, Lyles, R.H., and Schisterman, E.F. (2015) "Positing, fitting,
and selecting regression models for pooled biomarker data." \emph{Stat. Med}
\strong{34}(17): 2544--2558.

Schisterman, E.F., Vexler, A., Mumford, S.L. and Perkins, N.J. (2010) "Hybrid
pooled-unpooled design for cost-efficient measurement of biomarkers."
\emph{Stat. Med.} \strong{29}(5): 597--613.

Weinberg, C.R. and Umbach, D.M. (1999) "Using pooled exposure assessment to
improve efficiency in case-control studies." \emph{Biometrics} \strong{55}:
718--726.

Weinberg, C.R. and Umbach, D.M. (2014) "Correction to 'Using pooled exposure
assessment to improve efficiency in case-control studies' by Clarice R.
Weinberg and David M. Umbach; 55, 718--726, September 1999."
\emph{Biometrics} \strong{70}: 1061.

Whitcomb, B.W., Perkins, N.J., Zhang, Z., Ye, A., and Lyles, R. H. (2012)
"Assessment of skewed exposure in case-control studies with pooling."
\emph{Stat. Med.} \strong{31}: 2461--2472.
}
