% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/survival.R
\name{survtab}
\alias{survtab}
\title{Survival tables}
\usage{
survtab(data, surv.breaks = NULL, by.vars = NULL, event.values = NULL,
  surv.type = "surv.rel", surv.method = "hazard", relsurv.method = "e2",
  subset = NULL, agegr.w.breaks = NULL, agegr.w.weights = NULL,
  conf.level = 0.95, conf.type = "log-log", format = TRUE,
  verbose = FALSE)
}
\arguments{
\item{data}{a dataset processed by \code{\link{lexpand}}}

\item{surv.breaks}{breaks as explicitly
left inclusive and right exclusive - e.g. \code{[a,b)}.}

\item{by.vars}{a character string vector; defines names of
variables by which survivals are calculated
separately; e.g. \code{by.vars = c('sex', 'area')} computes
survivals separately for each combination
of \code{'sex'} and \code{'area'}.}

\item{event.values}{a vector of values present
in the datasets's \code{lex.Xst} column;
if \code{NULL}, uses all but the first
level of \code{as.factor(lex.Xst)} as \code{event.values};
these values are events and all other values are considered to be censoring}

\item{surv.type}{either \code{'surv.obs'},
\code{'surv.cause'}, \code{'surv.rel'},
\code{'cif.obs'} or \code{'cif.rel'};
defines what kind of survival time function(s) is/are estimated; see Details}

\item{surv.method}{either \code{'lifetable'} or \code{'hazard'}; determines
the method of calculating survival time functions}

\item{relsurv.method}{either \code{'e2'} or \code{'pp'};
defines whether to compute relative survival using the
EdererII method or using Pohar-Perme weighting;
ignored if \code{surv.type != "surv.rel"}}

\item{subset}{a logical condition; e.g. \code{subset = sex == 1};
subsets the data before computations}

\item{agegr.w.breaks}{optional; if not \code{NULL}, given breaks will be
used to define age groups in age group
weighting; given as left inclusive and right exclusive, e.g. [a,b)}

\item{agegr.w.weights}{optional; if \code{agegr.w.breaks} is not \code{NULL},
 the user can define a vector of weights
to give to each age group defined by \code{agegr.w.breaks};
if \code{agegr.w.weights} is \code{NULL},
internal weights (see Examples) are used if
\code{agegr.w.breaks} is not \code{NULL};
can also be one of \code{"ICSS1"}, \code{"ICSS2"}, and \code{"ICSS3"}
for internationally used standard weights ---
see References}

\item{conf.level}{confidence level used in confidence intervals;
e.g. \code{0.95} for 95 percent confidence intervals}

\item{conf.type}{character string; must be one of \code{"plain"},
\code{"log-log"} and \code{"log"};
defines the transformation used on the survival (and/or relative survival)
 function to yield confidence
intervals via the delta method}

\item{format}{logical; if \code{TRUE}, output is formatted into a neat table;
otherwise you get all the raw results}

\item{verbose}{logical; if \code{TRUE}, the function is chatty and
 returns some messages and timings along the process}
}
\value{
Returns a table of life time function values and other
information with survival intervals as rows.
Returns some of the following estimates of survival time functions:

\itemize{
 \item \code{surv.obs} - observed (raw) survival
 \item \code{CIF_k} - cumulative incidence function for cause \code{k}
 \item \code{CIF.rel} - cumulative incidence function using excess cases
 \item \code{r.e2} -  relative survival, EdererII
 \item \code{r.pp} -  relative survival, Pohar-Perme weighted
}
The suffix \code{.as} implies agegroup-standardisation, and \code{.lo} and
\code{.hi} imply lower and upper confidence limits, respectively.
The prefix \code{SE.} stands for standard error.
}
\description{
Given a data set processed by \code{lexpand}, estimates various
survival time functions as requested by the user.
}
\details{
\strong{Basics}

\code{survtab} creates survival tables using data split with e.g.
\code{\link{lexpand}}. We recommend using \code{lexpand} since
it is well tested and one usually needs to merge in population hazards
to ocmpute relative survivals.

 By default
\code{survtab} makes use of the exact same breaks that were used in
splitting (with e.g. \code{lexpand}), so it is not necessary to specify any
\code{surv.breaks}. If specified, the
\code{surv.breaks} must be a subset of the pertinent
breaks given in \code{lexpand}.

The function supplies \code{surv.breaks} to \code{\link{cut}} to
create survival intervals in the data,
e.g.

\code{surv.breaks=0:5 -> [0,1),[1,2), ..., [4,5)}.


Interval lengths (deltas) are also calculated based
on \code{surv.breaks}. The upper limit of the breaks should
be meaningful and never e.g. \code{Inf}.

if \code{surv.type = 'surv.obs'}, only 'raw' observed survival
is calculated over the chosen time intervals. With
\code{surv.type = 'surv.rel'}, also relative survival estimates
are supplied in addition to observed survival figures.

\code{surv.type = 'cif.obs'} requests cumulative incidence functions (CIF)
to be estimated, where all unique \code{event.values}
are seen as competing risks indicators
(others are random censoring indicators);
CIFs are estimated for each competing risk are computed based
on a survival-interval-specific proportional hazards
assumption as described by Chiang (1968) using the chosen \code{surv.method}.
With \code{surv.type = 'cif.rel'}, a CIF is estimated with using
excess cases as the ''cause-specific'' cases.

if \code{surv.type = 'surv.cause'}, cause-specific survivals are estimated
separately for each unique value of \code{event.values}.


\strong{Relative / net survival}

When \code{surv.type = 'surv.rel'}, the user can choose
\code{relsurv.method = 'pp'}, whereupon
additional Pohar-Perme weighting is used
to get closer to a true net survival measure.
By default \code{relsurv.method = 'e2'}.


\strong{Age-standardised survival}

The user can also apply age standardisation on top of
everything else. Then the requested survival figures
are calculated for each age group separately, and then a
weighted average of the age-group-specific survivals
is presented.

The user must define the age-standardisation age
groups and their weights with the \code{agegr.w.breaks}
and \code{agegr.w.weights} arguments. The numbers of
age groups and weights should match; e.g.
with \code{agegr.w.breaks = c(0,45,65,75,Inf)} the weights vector
must then have 4 elements.
The \code{agegr.w.weights} do not have to sum to one as
they are processed internally to do so.

If one wishes to use one of the three integrated international
standard weighting schemes available,
one must specify the weighting scheme by using e.g.
\code{agegr.w.weights = "ICSS1"}, and also
by specifying the used \code{agegr.w.breaks}. However, as
the weights are available only
for 5-year age groups, the \code{agegr.w.breaks} must all
(except the last) be divisible by 5;
e.g.

\code{agegr.w.breaks = c(0, 45, 65, 85, Inf)}.


You can see the weights integrated
into \pkg{popEpi} by typing \code{ICSS} into the console.
See also \code{\link{ICSS}}.

Note that the \code{by.vars} should not be confused with age-standardisation.
\code{by.vars} simply determine variables, for the unique combinations of which
survivals are computed and outputted separately.


\strong{Period analysis / delayed entry}

If one wishes to calculate period analysis / delayed entry estimates,
one should limit the data accordingly
when expanding the data; see \code{\link{lexpand}}.


\strong{Data requirements}

This function requires the data to contain,
at minimum, the variables
\code{lex.id}, \code{lex.dur},\code{lex.Cst},
\code{lex.Xst},  and \code{fot}; these will be enough to calculate
observed survivals.

Relative survivals require additional information. EdererII
relative survival requires the presence of a \code{pop.haz} variable in the data,
and Pohar-Perme weighting requires \code{pp} (the inverse cumulative population
survival). Both can be computed with \code{lexpand}.

You may take a look at a simulated cohort \code{\link{sire}} as an example of the
minimum required information for when processing data to be used in calculating
relative survival (in the Finnish context).
}
\examples{
## see more examples with explanations in vignette("survtab_examples")

## prepare data for e.g. 5-year "period analysis" for 2008-2012
## note: sire is a simulated cohort integrated into popEpi.
BL <- list(fot=seq(0, 5, by = 1/12),
           per = c("2008-01-01", "2013-01-01"))
x <- lexpand(sire, birth = bi_date, entry = dg_date, exit = ex_date,
             status = status \%in\% 1:2,
             breaks = BL,
             pophaz = popmort)

## calculate relative EdererII period method
## survivals using the fot.breaks given in lexpand()
st <- survtab(x)
}
\author{
Joonas Miettinen, Karri Seppa
}
\references{
Perme, Maja Pohar, Janez Stare, and Jacques Estève.
"On estimation in relative survival." Biometrics 68.1 (2012): 113-120.

Hakulinen, Timo, Karri Seppa, and Paul C. Lambert.
"Choosing the relative survival method for cancer survival estimation." European Journal of Cancer 47.14 (2011): 2202-2210.

Seppa, Karri, Timo Hakulinen, and Arun Pokhrel.
"Choosing the net survival method for cancer survival estimation." European Journal of Cancer (2013).

CHIANG, Chin Long. Introduction to stochastic processes in biostatistics. 1968.
}
\seealso{
\code{\link{splitMulti}}, \code{\link{lexpand}},
\code{\link{ICSS}}, \code{\link{sire}}
}

