% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{na2zero}
\alias{na2zero}
\title{Convert NA's to zero in data.table}
\usage{
na2zero(DT, vars = NULL)
}
\arguments{
\item{DT}{\code{data.table} object}

\item{vars}{a character string vector of variables names in \code{DT};
if \code{NULL}, uses all variable names in \code{DT}}
}
\description{
Given a \code{data.table DT}, replaces any \code{NA} values
in the variables given in \code{vars} in \code{DT}. Takes a copy of the 
original data and returns the modified copy.
}
\details{
Given a \code{data.table} object, converts \code{NA} values
to numeric (double) zeroes for all variables named in \code{vars} or
all variables if \code{vars = NULL}.
}
\author{
Joonas Miettinen
}

