% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-ProjectionClass.R
\docType{class}
\name{Projection-class}
\alias{Projection-class}
\alias{Projection-class}
\alias{Projection}
\alias{vec}
\alias{vec,Projection-method}
\alias{bounds}
\alias{bounds,Projection-method}
\alias{mat}
\alias{mat,Projection-method}
\alias{Aseq}
\alias{Aseq,Projection-method}
\alias{projtype}
\alias{projtype,Projection-method}
\alias{vectype}
\alias{vectype,Projection-method}
\alias{nproj}
\alias{nproj,Projection-method}
\alias{nmat}
\alias{nmat,Projection-method}
\alias{ntime}
\alias{ntime,Projection-method}
\title{'Projection' object S4 class}
\usage{
vec(object)

\S4method{vec}{Projection}(object)

bounds(object)

\S4method{bounds}{Projection}(object)

mat(object, ...)

\S4method{mat}{Projection}(object, return = "simple")

Aseq(object)

\S4method{Aseq}{Projection}(object)

projtype(object)

\S4method{projtype}{Projection}(object)

vectype(object)

\S4method{vectype}{Projection}(object)

nproj(object)

\S4method{nproj}{Projection}(object)

nmat(object)

\S4method{nmat}{Projection}(object)

ntime(object)

\S4method{ntime}{Projection}(object)
}
\arguments{
\item{object}{an object of class "Projection" generated using \code{\link{project}}
vec: access population vectors}

\item{...}{further arguments (see method, below)}

\item{return}{either "simple", "list", or "array": used for accessing the 'mat'
slot from a Projection object. Note that only list or array can be used for 
stochastic projections, which have more than one matrix.}
}
\description{
Projection objects are created using the \code{\link{project}} function. 
Primarily, they contain overall population size over time: they can be 
treated as a vector (single population projection) or matrix (multiple 
population projections; see information on slot ".Data" below). They also 
contain further information on the population projection. These extra pieces 
of information are described below in the "Slots" section, and the methods 
for accessing them appear below. These are:
\describe{
 \item{\code{vec}}{ access population vectors}
 \item{\code{bounds}}{ access bounds on population dynamics}
 \item{\code{mat}}{ access projection matrix/matrices used to create projection(s)}
 \item{\code{Aseq}}{ access projection matrix sequence used to create projection(s)}
 \item{\code{projtype}}{ find out projection type}
 \item{\code{vectype}}{ access type of vector used to initiate population projection(s)}
}
Other methods for accessing basic information from the projection are:
\describe{
 \item{\code{nproj}}{ access projection matrix/matrices used to create projection}
 \item{\code{nmat}}{ number of projection matrices used to create projection(s)}
 \item{\code{ntime}}{ number of time intervals}
}
Plotting and display methods for 'Projection' objects can be found on the 
\code{\link{Projection-plots}} page.
}
\details{
In addition to the examples below, see the "Deterministic population dynamics" 
and "Stochastic population dynamics" vignettes for worked examples that use 
the 'Projection' objects.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{One or more time series of population sizes. 
'Projection' objects inherit from a standard array, and can be treated as 
such. Therefore, if \code{vector} is specified, the 'Projection' object will 
behave as: 
\itemize{
 \item if a single \code{vector} is given, a numeric vector of population sizes 
 of length \code{time+1}
 \item if multiple \code{vector}s are given, a numeric matrix of population 
 projections where each column represents a single population projection and 
 is of length \code{time+1}
 \item if \code{vector="n"}, a numeric matrix of population projections where each column 
 represents a single stage-biased projection and is of length \code{time+1}.
 \item if \code{vector="diri"}, a numeric matrix of population projections where each 
 column represents projection of a single vector draw and each column is of 
 length \code{time+1}.
}}

\item{\code{vec}}{Age- or stage-based population vectors. \code{vec} 
will be:
\itemize{
 \item If a single \code{vector} is specified, a numeric matrix of demographic 
 vectors from projection of \code{vector} through \code{A}. Each column 
 represents the densities of one life (st)age in the projection.
 \item If multiple \code{vector}s are specified, a three-dimensional array of
 demographic vectors from projection of the set of initial vectors through
 \code{A}. The first dimension represents time (and is therefore equal to 
 \code{time+1}). The second dimension represents the densities of 
 each stage (and is therefore equal to the dimension of \code{A}). 
 The third dimension represents each individual projection (and is 
 therefore equal to the number of initial vectors given).
 \item If \code{vector="n"}, a three-dimensional array of demographic vectors from
 projection of the set of stage-biased vectors through \code{A}. The first 
 dimension represents time (and is therefore equal to \code{time+1}). The 
 second dimension represents the densities of each stage (and 
 is therefore equal to the dimension of \code{A}). The third 
 dimension represents each individual stage-biased projection (and is 
 therefore also equal to the dimension of \code{A}).
 \item If\code{vector="diri"}, a three-dimensional array of demographic vectors from
 projection of the dirichlet vector draws projected through \code{A}. The first 
 dimension represents time (and is therefore equal to \code{time+1}). The second 
 dimension represents the densities of each stage (and 
 is therefore equal to the dimension of \code{A}). The third 
 dimension represents projection of each population draw (and is therefore equal
 to \code{draws}).
}

Some examples for understanding the structure of 3D arrays returned when 
\code{return.vec=TRUE}: when projecting a 3 by 3 matrix for >10 time intervals, 
element [11,3,2] represents the density of stage 3 at time 10 
for either vector 2 (multiple vectors), stage-bias 2 (\code{vector="n"}) or draw 2 
(\code{vector="diri"}); note that because element 1 represents t=0, then t=10 
is found at element 11. The vector [,3,2] represents the time series of densities 
of stage 3 in the projection of vector 2 / stage-bias 2 / draw 2. The matrix [,,2] 
represents the time series of all stages in the projection of vector 2 / stage-bias 
2 / draw 2.


Note that the projections inherit the labelling from \code{A} and \code{vector}, if
it exists. Both stage and vector names are taken from the COLUMN names of \code{A} 
and \code{vector} respectively. These may be useful for selecting from the
\code{projection} object, and are used when labelling plots of Projection 
objects containing multiple population projections.


Set \code{return.vec = FALSE} when calling \code{project} to prevent population
vectors from being saved: in this case, \code{vec} is equal to 
\code{numeric(0)}. This may be necessary when projecting large numbers of
vectors, as is the case when \code{vector = "diri"}.}

\item{\code{bounds}}{The bounds on population dynamics (only for deterministic 
projections). These represent the maximum and minimum population sizes 
achieveable at each time interval of the projection. \code{bounds} is a 
matrix with 2 columns (lower and upper bounds, in that order), and the 
number of rows is equal to \code{time + 1}.}

\item{\code{mat}}{The matrix/matrices used in the population projection. In their 
raw form \code{mat} is always a three-dimensional array, where the third 
dimension is used to index the different matrices. However, by using the 
\code{mat()} accessor function below, it is possible to choose different ways
of representing the matrices (matrix, list, array).}

\item{\code{Aseq}}{The sequence of matrices used in the projection. For deterministic
projections (where there is only 1 matrix) this will always be \code{rep(1, time)}.
For stochastic projections (with more than 1 matrix), if \code{Aseq} is given 
to \code{project} as a numeric or character vector then this slot will take 
that value. If a matrix describing a random markov process is passed, the 
\code{Aseq} slot will be a single random chain.}

\item{\code{projtype}}{The type of projection. Either "deterministic" (single matrix; 
time-invariant), or "stochastic" (multiple matrices; time-varying).}

\item{\code{vectype}}{The type of vector passed to \code{project}. May be "single" 
(one vector; one population projection), "multiple" (more than one vector; 
several population projections), "bias" (stage-biased vectors; 
\code{vector = "n"}), or "diri" (vectors drawn from the dirichlet 
distribution; \code{vector = "diri"}).}
}}

\examples{
  ### USING PROJECTION OBJECTS

  # Create a 3x3 PPM
  ( A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3) )

  # Project stage-biased dynamics of A over 70 intervals
  ( pr <- project(A, vector="n", time=70) )
  plot(pr)

  # Access other slots
  vec(pr)  #time sequence of population vectors
  bounds(pr)  #bounds on population dynamics
  mat(pr)  #matrix used to create projection
  Aseq(pr)  #sequence of matrices (more useful for stochastic projections)
  projtype(pr)  #type of projection
  vectype(pr)  #type of vector(s) initiating projection

  # Extra information on the projection
  nproj(pr)  #number of projections
  nmat(pr)  #number of matrices (more usefulk for stochastic projections)
  ntime(pr)  #number of time intervals
  
  # Select the projection of stage 2 bias
  pr[,2]

  # Project stage-biased dynamics of standardised A over 30 intervals
  ( pr2 <- project(A, vector="n", time=30, standard.A=TRUE) )
  plot(pr2)

  #Select the projection of stage 2 bias
  pr2[,2]

  # Select the density of stage 3 in bias 2 at time 10
  vec(pr2)[11,3,2]

  # Select the time series of densities of stage 2 in bias 1
  vec(pr2)[,2,1]

  #Select the matrix of population vectors for bias 2
  vec(pr2)[,,2]

  # Create an initial stage structure
  ( initial <- c(1,3,2) )

  # Project A over 50 intervals using a specified population structure
  ( pr3 <- project(A, vector=initial, time=50) )
  plot(pr3)

  # Project standardised dynamics of A over 10 intervals using 
  # standardised initial structure and return demographic vectors
  ( pr4 <- project(A, vector=initial, time=10, standard.vec=TRUE, 
                   standard.A=TRUE, return.vec=TRUE) )
  plot(pr4)

  # Select the time series for stage 1
  vec(pr4)[,1]

  ### DETERMINISTIC PROJECTIONS

  # Load the desert Tortoise matrix
  data(Tort)

  # Create an initial stage structure
  Tortvec1 <- c(8, 7, 6, 5, 4, 3, 2, 1)
  
  # Create a projection over 30 time intervals
  ( Tortp1 <- project(Tort, vector = Tortvec1, time = 10) )

  # plot p1
  plot(Tortp1)
  plot(Tortp1, bounds = TRUE) #with bounds
 
  # new display parameters
  plot(Tortp1, bounds = TRUE, col = "red", bty = "n", log = "y", 
       ylab = "Number of individuals (log scale)",
       bounds.args = list(lty = 2, lwd = 2) )

  # multiple vectors
  Tortvec2 <- cbind(Tortvec1, c(1, 2, 3, 4, 5, 6, 7, 8))
  plot(project(Tort, vector = Tortvec2), log = "y")
  plot(project(Tort, vector = Tortvec2), log = "y", labs = FALSE) #no labels

  # dirichlet distribution 
  # darker shading indicates more likely population size
  plot(project(Tort, time = 30, vector = "diri", standard.A = TRUE,
               draws = 500, alpha.draws = "unif"),
       plottype = "shady", bounds = TRUE)
  
  ### STOCHASTIC PROJECTIONS
  # load polar bear data
  data(Pbear)
  
  # project over 50 years with uniform matrix selection
  Pbearvec <- c(0.106, 0.068, 0.106, 0.461, 0.151, 0.108)
  p2 <- project(Pbear, Pbearvec, time = 50, Aseq = "unif")

  # stochastic projection information
  Aseq(p2)
  projtype(p2)
  nmat(p2)
  
  # plot
  plot(p2, log = "y")
  
}
\seealso{
\code{\link{project}} \code{\link{Projection-plots}}
}
