% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amova.r
\name{poppr.amova}
\alias{poppr.amova}
\alias{amova}
\title{Perform Analysis of Molecular Variance (AMOVA) on genind or genclone objects.}
\usage{
poppr.amova(x, hier = NULL, clonecorrect = FALSE, within = TRUE,
  dist = NULL, squared = TRUE, freq = TRUE, correction = "quasieuclid",
  sep = "_", filter = FALSE, threshold = 0,
  algorithm = "farthest_neighbor", missing = "loci", cutoff = 0.05,
  quiet = FALSE, method = c("ade4", "pegas"), nperm = 0)
}
\arguments{
\item{x}{a \link[=genind-class]{genind} or \link[=genclone-class]{genclone} object}

\item{hier}{a hierarchical \link[=formula]{formula} that defines your population
hierarchy. (e.g.: \code{~Population/Subpopulation}). \strong{See Details below}.}

\item{clonecorrect}{\code{logical} if \code{TRUE}, the data set will be clone corrected
with respect to the lowest level of the hierarchy. The default is set to
\code{FALSE}. See \code{\link[=clonecorrect]{clonecorrect()}} for details.}

\item{within}{\code{logical}. When this is set to \code{TRUE} (Default), variance
within individuals are calculated as well. If this is set to \code{FALSE}, The
lowest level of the hierarchy will be the sample level. See Details below.}

\item{dist}{an optional distance matrix calculated on your data. If this is
set to \code{NULL} (default), the raw pairwise distances will be calculated via
\code{\link[=dist]{dist()}}.}

\item{squared}{if a distance matrix is supplied, this indicates whether or
not it represents squared distances.}

\item{freq}{\code{logical}. If \code{within = FALSE}, the parameter rho is calculated
(Ronfort et al. 1998; Meirmans and Liu 2018). By setting \code{freq = TRUE},
(default) allele counts will be converted to frequencies before the
distance is calculated, otherwise, the distance will be calculated on
allele counts, which can bias results in mixed-ploidy data sets. Note that
this option has no effect for haploid or presence/absence data sets.}

\item{correction}{a \code{character} defining the correction method for
non-euclidean distances. Options are \code{\link[ade4:quasieuclid]{ade4::quasieuclid()}} (Default),
\code{\link[ade4:lingoes]{ade4::lingoes()}}, and \code{\link[ade4:cailliez]{ade4::cailliez()}}. See Details below.}

\item{sep}{Deprecated. As of poppr version 2, this argument serves no
purpose.}

\item{filter}{\code{logical} When set to \code{TRUE}, mlg.filter will be run to
determine genotypes from the distance matrix. It defaults to \code{FALSE}. You
can set the parameters with \code{algorithm} and \code{threshold} arguments. Note
that this will not be performed when \code{within = TRUE}. Note that the
threshold should be the number of allowable substitutions if you don't
supply a distance matrix.}

\item{threshold}{a number indicating the minimum distance two MLGs must be
separated by to be considered different. Defaults to 0, which will reflect
the original (naive) MLG definition.}

\item{algorithm}{determines the type of clustering to be done. 
\describe{
  \item{"farthest_neighbor"}{\emph{ (default) }merges clusters based on the 
  maximum distance between points in either cluster. This is the strictest of
  the three.}
  \item{"nearest_neighbor"}{ merges clusters based on the minimum distance
  between points in either cluster. This is the loosest of the three.}
  \item{"average_neighbor"}{ merges clusters based on the average distance
  between every pair of points between clusters.}
}}

\item{missing}{specify method of correcting for missing data utilizing
options given in the function \code{\link[=missingno]{missingno()}}. Default is \code{"loci"}.}

\item{cutoff}{specify the level at which missing data should be
removed/modified. See \code{\link[=missingno]{missingno()}} for details.}

\item{quiet}{\code{logical} If \code{FALSE} (Default), messages regarding any
corrections will be printed to the screen. If \code{TRUE}, no messages will be
printed.}

\item{method}{Which method for calculating AMOVA should be used? Choices
refer to package implementations: "ade4" (default) or "pegas". See details
for differences.}

\item{nperm}{the number of permutations passed to the pegas implementation of
amova.}
}
\value{
a list of class \code{amova} from the ade4 or pegas package. See
\code{\link[ade4:amova]{ade4::amova()}} or \code{\link[pegas:amova]{pegas::amova()}} for details.
}
\description{
This function simplifies the process necessary for performing AMOVA in R. It
gives user the choice of utilizing either the \pkg{ade4} or the \pkg{pegas}
implementation of AMOVA. See \code{\link[ade4:amova]{ade4::amova()}} (ade4) and \code{\link[pegas:amova]{pegas::amova()}}
(pegas) for details on the specific implementation.
}
\examples{
data(Aeut)
strata(Aeut) <- other(Aeut)$population_hierarchy[-1]
agc <- as.genclone(Aeut)
agc
amova.result <- poppr.amova(agc, ~Pop/Subpop)
amova.result
amova.test <- randtest(amova.result) # Test for significance
plot(amova.test)
amova.test

\dontrun{

# You can get the same results with the pegas implementation
amova.pegas <- poppr.amova(agc, ~Pop/Subpop, method = "pegas")
amova.pegas
amova.pegas$varcomp/sum(amova.pegas$varcomp)

# Clone correction is possible
amova.cc.result <- poppr.amova(agc, ~Pop/Subpop, clonecorrect = TRUE)
amova.cc.result
amova.cc.test <- randtest(amova.cc.result)
plot(amova.cc.test)
amova.cc.test


# Example with filtering
data(monpop)
splitStrata(monpop) <- ~Tree/Year/Symptom
poppr.amova(monpop, ~Symptom/Year) # gets a warning of zero distances
poppr.amova(monpop, ~Symptom/Year, filter = TRUE, threshold = 0.1) # no warning


}
}
\references{
Excoffier, L., Smouse, P.E. and Quattro, J.M. (1992) Analysis of
molecular variance inferred from metric distances among DNA haplotypes:
application to human mitochondrial DNA restriction data. \emph{Genetics},
\strong{131}, 479-491.

Ronfort, J., Jenczewski, E., Bataillon, T., and Rousset, F. (1998). Analysis
of population structure in autotetraploid species. \emph{Genetics}, \strong{150},
921–930.

Meirmans, P., Liu, S. (2018) Analysis of Molecular Variance (AMOVA) for
Autopolyploids \emph{Submitted}.
}
\seealso{
\code{\link[ade4:amova]{ade4::amova()}}, \code{\link[pegas:amova]{pegas::amova()}}, \code{\link[=clonecorrect]{clonecorrect()}}, \code{\link[=diss.dist]{diss.dist()}},
\code{\link[=missingno]{missingno()}}, \code{\link[ade4:is.euclid]{ade4::is.euclid()}}, \code{\link[=strata]{strata()}}, \code{\link[=make_haplotypes]{make_haplotypes()}},
\code{\link[=as.genambig]{as.genambig()}}
}
\keyword{amova}
