% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_label_female}
\alias{find_label_female}
\title{Identify Sex or Gender Labels Referring to Females}
\usage{
find_label_female(nms)
}
\arguments{
\item{nms}{A character vector}
}
\value{
An element of \code{nms} or \code{NULL}.
}
\description{
Given labels for sex or gender, try to infer
which (if any) refer to females.
If no elements look like a label for females,
or if two or more elements do,
then return \code{NULL}.
}
\examples{
find_label_female(c("Female", "Male")) ## one valid
find_label_female(c("0-4", "5-9"))     ## none valid
find_label_female(c("F", "Fem"))       ## two valid
}
\seealso{
\code{\link[=find_label_male]{find_label_male()}}, \code{\link[=find_var_sexgender]{find_var_sexgender()}}
}
