% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_rodents.R
\name{summarize_rodent_data}
\alias{summarize_rodent_data}
\alias{abundance}
\alias{biomass}
\alias{energy}
\alias{summarise_rodent_data}
\title{Generate summaries of Portal rodent data}
\usage{
summarize_rodent_data(path = get_default_data_path(), clean = TRUE,
  level = "Site", type = "Rodents", length = "all", plots = length,
  unknowns = FALSE, shape = "crosstab", time = "period",
  output = "abundance", fillweight = (output != "abundance"),
  na_drop = TRUE, zero_drop = switch(tolower(level), plot = FALSE,
  treatment = TRUE, site = TRUE), min_traps = 1, min_plots = 24,
  effort = FALSE, download_if_missing = TRUE, quiet = FALSE,
  include_unsampled = FALSE)

abundance(...)

biomass(...)

energy(...)

summarise_rodent_data(path = get_default_data_path(), clean = TRUE,
  level = "Site", type = "Rodents", length = "all", plots = length,
  unknowns = FALSE, shape = "crosstab", time = "period",
  output = "abundance", fillweight = (output != "abundance"),
  na_drop = TRUE, zero_drop = switch(tolower(level), plot = FALSE,
  treatment = TRUE, site = TRUE), min_traps = 1, min_plots = 24,
  effort = FALSE, download_if_missing = TRUE, quiet = FALSE,
  include_unsampled = FALSE)
}
\arguments{
\item{path}{either the file path that contains the PortalData folder or
"repo", which then pulls data from the PortalData GitHub repository}

\item{clean}{logical, load only QA/QC rodent data (TRUE) or all data (FALSE)}

\item{level}{summarize by "Plot", "Treatment", or "Site"}

\item{type}{specify subset of species; either all "Rodents" or only
"Granivores"}

\item{length}{specify subset of plots; use "All" plots or only "Longterm"
plots (to be deprecated)}

\item{plots}{specify subset of plots; can be a vector of plots, or specific
sets: "all" plots or "Longterm" plots (plots that have had the same
treatment for the entire time series)}

\item{unknowns}{either removes all individuals not identified to species
(unknowns = FALSE) or sums them in an additional column (unknowns = TRUE)}

\item{shape}{return data as a "crosstab" or "flat" list}

\item{time}{specify the format of the time index in the output, either
"period" (sequential Portal surveys), "newmoon" (lunar cycle numbering),
"date" (calendar date), or "all" (for all time indices)}

\item{output}{specify whether to return "abundance", or "biomass", or
"energy"}

\item{fillweight}{specify whether to fill in unknown weights with other
records from that individual or species, where possible}

\item{na_drop}{logical, drop NA values (representing insufficient sampling)}

\item{zero_drop}{logical, drop 0s (representing sufficient sampling, but no
detections)}

\item{min_traps}{minimum number of traps for a plot to be included}

\item{min_plots}{minimum number of plots within a period for an
observation to be included}

\item{effort}{logical as to whether or not the effort columns should be
included in the output}

\item{download_if_missing}{if the specified file path doesn't have the
PortalData folder, then download it}

\item{quiet}{logical, whether to run without producing messages}

\item{include_unsampled}{logical, overrides settings for `na_drop` and
`zero_drop`, setting both to FALSE}

\item{...}{arguments passed to \code{\link{summarize_rodent_data}}}
}
\value{
a data.frame in either "long" or "wide" format, depending on the
  value of `shape`
}
\description{
This function is a generic interface into creating summaries
  of the Portal rodent species data. It contains a number of arguments
  to specify the kind of data to summarize (at what level of aggregation)
  and various choices for dealing with data quality, and output format.

\code{abundance} generates a table of rodent abundance

* \code{biomass()} generates a table of rodent biomass

* \code{energy()} generates a table of rodent energy
  (computed as 5.69 * (biomass ^ 0.75) after White et al 2004)
}
\examples{
\donttest{
abundance("repo")
}
\donttest{
biomass("repo")
}
\donttest{
energy("repo")
}
}
