% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_mail.R
\name{fetch_mail}
\alias{fetch_mail}
\title{Fetch postage details}
\usage{
fetch_mail(origin_zip = NULL, destination_zip = NULL,
  shipping_date = "today", shipping_time = "now", type = "package",
  ground_transportation_needed = FALSE, live_animals = FALSE,
  day_old_poultry = FALSE, hazardous_materials = FALSE, pounds = 0,
  ounces = 0, length = 0, height = 0, width = 0, girth = 0,
  shape = "rectangular", show_details = FALSE, n_tries = 3,
  verbose = TRUE)
}
\arguments{
\item{origin_zip}{(character) A single 5-digit origin zip code.}

\item{destination_zip}{(character) A single 5-digit destination zip code.}

\item{shipping_date}{(character) Date you plan to ship the package on in "MM-DD-YYYY" format as character, or "today".}

\item{shipping_time}{(character) Time of day you plan to ship in 24-hour "HH:MM" format as character, or "now".}

\item{type}{(character) One of: "box", "envelope", "package". The types "box" and "envelope" refer to flat-rate boxes and envelopes.}

\item{ground_transportation_needed}{(boolean) does the package need to be transported by ground?}

\item{live_animals}{(boolean) Does this contain live animals? See \url{https://pe.usps.com/text/pub52/pub52c5_003.htm} for more details.}

\item{day_old_poultry}{(boolean) Does this contain day-old poultry? See \url{https://pe.usps.com/text/pub52/pub52c5_008.htm#ep184002} for more details.}

\item{hazardous_materials}{(boolean) Does this contain any hazardous materials? See \url{https://pe.usps.com/text/pub52/pub52c3_001.htm} for more details.}

\item{pounds}{(numeric) Number of pounds the package weighs.}

\item{ounces}{(numeric) Number of ounces the package weighs.}

\item{length}{(numeric) Length of the package in inches. This is the longest dimension.}

\item{height}{(numeric) Height of the package in inches.}

\item{width}{(numeric) Width of the package in inches.}

\item{girth}{(numeric) Girth of the package in inches. Required if \code{shape} is "nonrectangular". This is the distance around the thickest part.}

\item{shape}{(character) Shape of the package: "rectangular" or "nonrectangular". "nonrectangular" requires a non-null \code{girth} value.
If \code{type} is box or envelope, \code{shape} will always be "rectangular".}

\item{show_details}{(boolean) Non-essential details of the response are hidden by default. Show them by setting this to TRUE.}

\item{n_tries}{(numeric) How many times to try the API if at first we don't succeed.}

\item{verbose}{(boolean) Should information like the shipping date time be displayed if the defaults "today" and "now" are chosen be messaged?}
}
\value{
A tibble with information for different postage options, including price and box/envelope dimensions.
}
\description{
Get postage options for a flat-rate envelope, flat-rate box, or package.
}
\details{
Supply the required information about the package and receive a tibble. Displays the result of a query to the  \href{https://postcalc.usps.com/Calculator/}{"Postage Price Calculator"} in dataframe format. The inputs \code{origin_zip}, \code{destination_zip}, \code{shipping_date}, and \code{shipping_time} are included in the result.

If \code{type} is "envelope" or "box", the response is the same regardless of measurements (\code{pounds}, \code{ounces}, \code{height}, \code{width}, \code{girth} and \code{shape}) applied. These only vary outcomes for "package"s.

The result can be further cleaned and standardized by piping the result to \code{scrub_mail}.

Multiple origins, destinations, and other options can be supplied and mapped together using, e.g. \code{purrr::pmap}.

The API is tried \code{n_tries} times until a tibble is returned with \code{no_success} in columns that could not be returned. This indicates either that the connection was interrupted during the request or that one or more of the arguments supplied were malformed.

If a response is successfully received but there are no shipping options, the columns are filled with \code{NA}s.
}
\examples{
\dontrun{

fetch_mail(origin_zip = "90210",
         destination_zip = "59001",
         type = "envelope")


fetch_mail(origin_zip = "68003",
         destination_zip = "23285",
         pounds = 4,
         ground_transportation_needed = TRUE,
         type = "package",
         shape = "rectangular",
         show_details = TRUE)

# Contains an invalid zip ("foobar"), which will get a "no_success" row
origins <- c("90210", "foobar", "59001")
destinations <- c("68003", "94707", "23285")

purrr::map2_dfr(
  origins, destinations,
  fetch_mail,
  type = "package"
)

# A syntactically fine request, but no results are returned
fetch_mail(origin_zip = "04101",
    destination_zip = "97211",
    shipping_date = "3018-07-04",  # way in the future!
    type = "package",
    show_details = TRUE)

}

}
\seealso{
\link{scrub_mail}
}
