% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/give.R
\name{give}
\alias{give}
\title{Extract information from \code{powRICLPM} object}
\usage{
give(from, what, parameter = NULL)
}
\arguments{
\item{from}{A \code{powRICLPM} object}

\item{what}{A character string denoting the information to extract, either "conditions", "estimation_problems", "results", or "names".}

\item{parameter}{(optional) When \code{what = "results"}, a character string denoting the parameter to extract the results for.}
}
\value{
A \code{data.frame}.
}
\description{
Extract information stored within a \code{powRICLPM} object (internally used by \code{\link{print.powRICLPM}} and \code{\link{summary.powRICLPM}}). See "Details" for which pieces of information can be extracted. The information is presented by condition (i.e., sample size, number of time points, and ICC).
}
\details{
The following information can be extracted from the \code{powRICLPM} object:

\itemize{
  \item \code{conditions}: A \code{data.frame} with the different experimental conditions per row, where each condition is defined by a unique combination of sample size, number of time points and ICC.
  \item \code{estimation_problems}: The proportion of fatal errors, inadmissible values, or non-converged estimations (columns) per experimental conditions (row).
  \item \code{results}: The average estimate (\code{Avg}), minimum estimate (\code{Min}), standard deviation of parameter estimates (\code{stdDev}), the average standard error (\code{SEavg}), the mean square error (\code{MSE}), the average width of the confidence interval (\code{Acc}), the coverage rate (\code{Cov}), and the proportion of times the \emph{p}-value was lower than the significance criterion (\code{Pow}). It requires setting the \code{parameter = "..."} argument.
  \item \code{names}: The parameter names in the condition with the least parameters (i.e., parameter names that apply to each experimental condition).
}
}
\examples{
load(system.file("extdata", "power_preliminary.Rds", package = "powRICLPM"))

# Return data frame with number of estimation problems per experimental condition
give(power_preliminary, "estimation_problems")

# Return data frame with performance measures for "wB2~wA1" per experimental condition
give(power_preliminary, "results", parameter = "wB2~wA1")
}
