% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.powRICLPM}
\alias{plot.powRICLPM}
\title{Plot results from \code{powRICLPM} object}
\usage{
\method{plot}{powRICLPM}(x, y, ..., parameter = NULL)
}
\arguments{
\item{x}{A \code{powRICLPM} object.}

\item{y}{(don't use)}

\item{...}{(don't use)}

\item{parameter}{Character string of length denoting the parameter to visualize the results for.}
}
\value{
A \code{ggplot2} object.
}
\description{
Visualizes (using \pkg{ggplot2}) the estimated power across all experimental conditions within the \code{powRICLPM} object, \emph{for a specific parameter}. The plots display the relation between sample size (x-axis) and power (y-axis), grouped by the number of time points, and wrapped by the proportion of between-unit variance.
}
\details{
\subsection{Manually creating plots}{\code{plot.powRICLPM()} creates arguably the most obvious plot in the context of power analysis: The relation between power and sample size. However, \code{powRICLPM} computes several other metrics (e.g., accuracy, coverage rate, etc.) that researchers might want to plot. To this end, I suggest that users use \code{give()} to collect other metrics, across all experimental conditions, for a specific parameter, into a data frame first. Then, users can use any plotting function they like to create their own manual plot. See "Details" of \code{\link{give}()} for a list of measures that are computed by the function.}
}
\examples{
load(system.file("extdata", "power_preliminary.Rds", package = "powRICLPM"))

# Visualize power for "wB2~wA1" across all simulation conditions
plot(power_preliminary, parameter = "wB2~wA1")

# Error: No parameter specified
try(plot(power_preliminary))
}
\seealso{
\itemize{
  \code{\link{give}}: Extract information (e.g., performance measures) for a specific parameter, across all experimental conditions. This function is used internally in \code{plot.powRICLPM}.
}
}
