% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.powRICLPM}
\alias{summary.powRICLPM}
\title{Summarize setup and results from \code{powRICLPM} object}
\usage{
\method{summary}{powRICLPM}(
  object,
  ...,
  parameter = NULL,
  sample_size = NULL,
  time_points = NULL,
  ICC = NULL
)
}
\arguments{
\item{object}{A \code{powRICLPM} object.}

\item{...}{(don't use) Additional arguments not affecting the summary produced.}

\item{parameter}{Character string of length denoting the parameter to visualize the results for.}

\item{sample_size}{(optional) An \code{integer}, denoting the sample size of the experimental condition of interest.}

\item{time_points}{(optional) An \code{integer}, denoting the number of time points of the experimental condition of interest.}

\item{ICC}{(optional) A \code{double}, denoting the proportion of variance at the between-unit level of the experimental condition of interest.}
}
\value{
No return value, called for side effects.
}
\description{
S3 method for class \code{powRICLPM}. \code{summary.powRICLPM} summarizes and outputs the setup and results of the \code{powRICLPM} analysis. Depending on the arguments that are set, \code{summary.powRICLPM} provides a different summary (see "Details").
}
\details{
\code{summary.powRICLPM} provides a different summary of the \code{powRICLPM} object, depending on the additional arguments that are set:
\itemize{
  \item When \code{sample_size = ...}, \code{time_points = ...}, and \code{ICC = ...} are set: Estimation information and results for all parameters of the experimental condition denoted by \code{sample_size}, \code{time_points}, and \code{ICC}.
  \item When \code{parameter = "..."} is set: Estimation information and results for a specific parameter across all experimental conditions.
  \item No additional arguments: Characteristics of the different experimental conditions are summarized, as well as session info (information that applies to each conditions, such the number of replications, etc.).
}
}
\examples{
load(system.file("extdata", "power_preliminary.Rds", package = "powRICLPM"))

# Get setup of powRICLPM analysis and convergence issues
summary(power_preliminary)

# Performance measures for "wB2~wA1" parameter across experimental conditions
summary(power_preliminary, parameter = "wB2~wA1")

# Performance measures for all parameters, for specific experimental condition
summary(power_preliminary, sample_size = 600, time_points = 4, ICC = .5)

}
