% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UPI.R
\name{UPI}
\alias{UPI}
\title{Unconstrained Product Indicator approach by Marsh et al. (2004), with extensions by Kelava and Brandt (2009)}
\usage{
UPI(
  lavModel_Analysis,
  data,
  data_transformations = NULL,
  matchPI = TRUE,
  PIcentering = "doubleMC",
  liberalInspection = FALSE
)
}
\arguments{
\item{lavModel_Analysis}{the lavModel_Analysis object}

\item{data}{set to fit}

\item{data_transformations}{Data transformations}

\item{matchPI}{Logical passed to \code{semTools::indProd} in order to compute the product indicators: Specify TRUE to use match-paired approach (Marsh, Wen, & Hau, 2004). If FALSE, the resulting products are all possible products. Default to \code{TRUE}. The observations are matched by order given when specifying the measurement model.}

\item{PIcentering}{String indicating which method of centering should be used when constructing product indicators. String is converted to the arguments \code{meanC}, \code{doubleMC}, and \code{residualMC}, of the \code{semTools::indProd} function. Default to \code{"doubleMC"} for double mean centering the resulting products (Lin et. al., 2010). Use \code{"meanC"} for mean centering the main effect indicator before making the products or \code{"residualC"} for residual centering the products by the main effect indicators (Little, Bovaird, & Widaman, 2006). \code{"none"} or any other input than the previously described results in no centering (use with caution!).}

\item{liberalInspection}{Logical whether the inspection of estimation truthworthiness should be very liberal (i.e., allowing for non-positive definite Hessians in standard error estimation or non-positive residual covariance matrices or latent covariance matrices). Default to \code{FALSE}. Being liberal is not adviced and should be checked for a single data set!}
}
\value{
Returns a \code{data.frame} that includes parameter estimates estimated using UPI.
}
\description{
Unconstrained Product Indicator approach by Marsh et al. (2004), with extensions by Kelava and Brandt (2009)
}
\references{
Kelava, A., & Brandt, H. (2009). Estimation of nonlinear latent structural equation models using the extended unconstrained approach. \emph{Review of Psychology, 16}(2), 123–132.

Lin, G. C., Wen, Z., Marsh, H. W., & Lin, H. S. (2010). Structural equation models of latent interactions: Clarification of orthogonalizing and double-mean-centering strategies. \emph{Structural Equation Modeling, 17}(3), 374–391. \doi{10.1080/10705511.2010.488999}

Little, T. D., Bovaird, J. A., & Widaman, K. F. (2006). On the merits of orthogonalizing powered and product terms: Implications for modeling interactions among latent variables. \emph{Structural Equation Modeling, 13}(4), 497–519. \doi{10.1207/s15328007sem1304_1}

Marsh, H. W., Wen, Z. & Hau, K. T. (2004). Structural equation models of latent interactions: Evaluation of alternative estimation strategies and indicator construction. \emph{Psychological Methods, 9}(3), 275–300. \doi{10.1037/1082-989X.9.3.275}

Marsh, H. W.,  Wen, Z., Hau, K. T., Little, T. D., Bovaird, J. A., & Widaman, K. F. (2007). Unconstrained Structural Equation Models of Latent Interactions: Contrasting Residual- and Mean-Centered Approaches. \emph{Structural Equation Modeling: A Multidisciplinary Journal, 14}(4), 570-580. \doi{10.1080/10705510701303921}
}
