% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-helpers.R
\name{.compute_assurance}
\alias{.compute_assurance}
\title{Compute Mean Assurance for a Given Metric (Multi-Effect Compatible)
Summarises simulation results and computes proportion passing for decision rule metric.}
\usage{
.compute_assurance(
  df,
  metric,
  prob_threshold,
  rope_rule = c(">="),
  direction_p = 0.5,
  effect_cols = NULL
)
}
\arguments{
\item{df}{Data frame containing simulation results with columns n, effect cols, ok, and metric columns.}

\item{metric}{One of "direction", "threshold", "rope".}

\item{prob_threshold}{Numeric, threshold for "threshold" and "rope" metrics.}

\item{rope_rule}{Reserved for future use.}

\item{direction_p}{Numeric cutoff for "direction" metric (default 0.5).}

\item{effect_cols}{Optional character vector of effect columns to group by. If NULL, auto-detects "true_effect" or others.}
}
\value{
Tibble grouped by n and effects with assurance column.
}
\description{
Compute Mean Assurance for a Given Metric (Multi-Effect Compatible)
Summarises simulation results and computes proportion passing for decision rule metric.
}
\keyword{internal}
