% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova2way.F.unbal.R
\name{anova2way.F.unbal}
\alias{anova2way.F.unbal}
\title{Power calculation for two-way unbalanced analysis of variance F tests}
\usage{
anova2way.F.unbal(
  nmatrix = NULL,
  mmatrix = NULL,
  sd = NULL,
  Rsq = 0,
  ncov = 0,
  alpha = 0.05,
  v = FALSE
)
}
\arguments{
\item{nmatrix}{A matrix of cell sample sizes (see example).}

\item{mmatrix}{A matrix of cell means (see example).}

\item{sd}{The estimated standard deviation within each cell}

\item{Rsq}{The estimated R^2 for regressing the outcome on the covariates; defaults to 0.}

\item{ncov}{The number of covariates adjusted for in the model; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed power).
}
\description{
Performs sample size and power calculations for F tests in a two-way
ANOVA with unbalanced data (that is, unequal sized cells). For given
matrix of cell means and matrix of cell sample sizes, computes power
for each factor and for their interaction, if an interaction is present.
This function does not solve for cell sizes.
For balanced data (equal cell sizes),
see anova2way.F.unbal, which can solve for cell size.
}
\examples{
nmatrix <- matrix(c(30, 30, 30, 30, 30, 30), nrow = 2, byrow = TRUE)
mmatrix <- matrix(c(9.3, 8.9, 8.5, 8.7, 8.3, 7.9), nrow = 2, byrow = TRUE)
anova2way.F.unbal(nmatrix = nmatrix, mmatrix = mmatrix, sd = 2, alpha = 0.05)
nmatrix <- matrix(c(30, 30, 30, 30, 30, 30), nrow = 2, byrow = TRUE)
mmatrix <- matrix(c(9.3, 8.9, 8.5, 8.7, 8.3, 7.3), nrow = 2, byrow = TRUE)
anova2way.F.unbal(nmatrix = nmatrix, mmatrix = mmatrix, sd = 2, alpha = 0.05)
nmatrix <- matrix(c(30, 30, 30, 30, 30, 30), nrow = 2, byrow = TRUE)
mmatrix <- matrix(c(9.3, 8.9, 8.5, 8.7, 8.3, 7.9), nrow = 2, byrow = TRUE)
anova2way.F.unbal(nmatrix = nmatrix, mmatrix = mmatrix, sd = 2, Rsq = 0.4^2,
ncov = 1, alpha = 0.05)
}
