% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{ExampleDataBinary}
\alias{ExampleDataBinary}
\title{Example data with binary outcomes}
\format{
A list containing the following elements:
\describe{
\item{Y}{a vector representing binary outcomes with 0 or 1.
Generated from a Bernoulli distribution with the probability of success (\eqn{\boldsymbol{\mu}}), which is
determined by applying the logistic function to the linear combination of provider effects and covariates.}
\item{ProvID}{a vector representing identifier for each provider.
The number of individuals per provider is generated from a
Poisson distribution with mean 80, with a minimum value of 11.}
\item{Z}{a data frame containing 5 continuous variables.
Generated from a multivariate normal distribution, where the mean is calculated as
\eqn{(\gamma_i - \mu_{\gamma}) \cdot \rho / \sigma_{\gamma}} with \eqn{\mu_{\gamma} = \log(4/11)} and \eqn{\sigma_{\gamma} = 0.4},
and the correlation between covariates and provider effects is 0.1.}
}
}
\usage{
data(ExampleDataBinary)
}
\description{
A simulated data set containing 7994 observations, 5 continuous covariates and 100 providers.
}
\examples{
data(ExampleDataBinary)
head(ExampleDataBinary$Y)
head(ExampleDataBinary$ProvID)
head(ExampleDataBinary$Z)
}
\keyword{datasets}
