% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{estimation.pqrBayes}
\alias{estimation.pqrBayes}
\title{Estimation and estimation accuracy for a pqrBayes object}
\usage{
estimation.pqrBayes(object,coefficient,u.grid=NULL,model="linear")
}
\arguments{
\item{object}{an object of class `pqrBayes'.}

\item{coefficient}{the vector of quantile regression coefficients under a linear model or the matrix of true varying coefficients evaluated on the grid points under a varying coefficient model.}

\item{u.grid}{the vector of grid points under a varying coefficient model. When fitting a linear (quantile) regression model, u.grid = NULL.}

\item{model}{the model to be fitted. Users can choose "linear" for a linear model or "VC" for a varying coefficient model.}
}
\value{
an object of class `pqrBayes.est' is returned, which is a list with components:
\item{error}{mean square error or integrated mean square errors and total integrated mean square error.}
\item{coeff.est}{estimated values of the regression coefficients or the varying coefficients.}
}
\description{
Calculate estimated regression coefficients with estimation accuracy from linear and quantile VC models, respectively.
}
\seealso{
\code{\link{pqrBayes}}
}
