% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praat_pitchRawAC.R
\name{praat_pitchRawAC}
\alias{praat_pitchRawAC}
\title{Estimate pitch using Praat's raw autocorrelation function}
\usage{
praat_pitchRawAC(
  sound,
  output = "ssff",
  timeStep = NULL,
  floor = 75,
  ceiling = 600,
  maxNoCandidates = 15,
  gaussianWindow = FALSE,
  silenceThreshold = 0.03,
  voicingThreshold = 0.45,
  octaveCost = 0.01,
  octaveJumpCost = 0.35,
  voicedUnvoicedCost = 0.14
)
}
\arguments{
\item{sound}{String giving the file name of a sound file with the .wav
extension.}

\item{output}{String giving the output format. Should be either \code{ssff}
for the SSFF-style format used by \code{wrassp} (default) or \code{df} to output a
data frame.}

\item{timeStep}{Measurement interval in seconds.
Default is \code{NULL}, in which case the measurement interval is equal to
0.75 / \code{pitch_floor}.}

\item{floor}{Frequency in Hz; no pitch candidates considered below
this frequency. Default is \code{75}.}

\item{ceiling}{Frequency in Hz; no pitch candidates considered above
this frequency. Default is \code{600}.}

\item{maxNoCandidates}{Integer giving the maximum number of pitch candidates
to estimate. Default is \code{15}.}

\item{gaussianWindow}{Logical; should Gaussian windows be used for
estimating pitch? Default is \code{FALSE}, in which case Hanning windows are used.}

\item{silenceThreshold}{Numeric giving the silence threshold when estimating
pitch in terms of amplitude relative to the global maximum. Default is
\code{0.01}.}

\item{voicingThreshold}{Numeric giving the voicing threshold when estimating
pitch in terms of fractional strength in the autocorrelation function.
Default is \code{0.14}.}

\item{octaveCost}{Numeric specifying how much high frequency pitch candidates
should be favored in terms of fractional strength in the autocorrelation
function. Default is \code{0.01}.}

\item{octaveJumpCost}{Numeric specifying how much pitch changes should be
disfavored in terms of fractional strength in the autocorrelation function.
Default is \code{0.35}.}

\item{voicedUnvoicedCost}{Numeric specifying how much transitions in voicing
value should be disfavored in terms of fractional strength in the
autocorelation function. Default is \code{0.14}.}
}
\value{
List in the SSFF format or data frame with estimated pitch.
}
\description{
Estimate pitch using Praat's raw autocorrelation function
}
\examples{
\dontrun{
1+1
}
}
