% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praatpicture.R
\name{praatpicture}
\alias{praatpicture}
\title{Make Praat Picture style plots of acoustic data}
\usage{
praatpicture(
  sound,
  start = 0,
  end = 0,
  tfrom0 = TRUE,
  tUnit = "s",
  frames = c("sound", "spectrogram", "TextGrid"),
  proportion = c(30, 50, 20),
  mainTitle = "",
  mainTitleAlignment = 0,
  start_end_only = TRUE,
  min_max_only = TRUE,
  drawSize = 1,
  speckleSize = 1,
  wave_channels = "all",
  wave_channelNames = FALSE,
  wave_energyRange = NULL,
  wave_axisDigits = 3,
  wave_color = "black",
  wave_lineWidth = 1,
  wave_highlight = NULL,
  tg_obj = NULL,
  tg_file = NULL,
  tg_tiers = "all",
  tg_focusTier = tg_tiers[1],
  tg_focusTierColor = "black",
  tg_focusTierLineType = "dotted",
  tg_tierNames = TRUE,
  tg_alignment = "central",
  tg_edgeLabels = "keep",
  tg_specialChar = FALSE,
  tg_color = "black",
  tg_highlight = NULL,
  spec_channel = NULL,
  spec_freqRange = c(0, 5000),
  spec_windowLength = 0.005,
  spec_dynamicRange = 50,
  spec_timeStep = 1000,
  spec_windowShape = "Gaussian",
  spec_colors = c("white", "black"),
  spec_axisLabel = "Frequency (Hz)",
  spec_highlight = NULL,
  pitch_timeStep = NULL,
  pitch_floor = 75,
  pitch_ceiling = 600,
  pitch_plotType = "draw",
  pitch_scale = "hz",
  pitch_freqRange = NULL,
  pitch_semitonesRe = 100,
  pitch_color = "black",
  pitch_plotOnSpec = FALSE,
  pitch_plotOnWave = FALSE,
  pitch_ssff = NULL,
  pitch_axisLabel = NULL,
  pitch_highlight = NULL,
  formant_timeStep = NULL,
  formant_maxN = 5,
  formant_windowLength = 0.025,
  formant_dynamicRange = 30,
  formant_freqRange = c(50, 5500),
  formant_number = NULL,
  formant_plotType = "speckle",
  formant_color = "black",
  formant_plotOnSpec = FALSE,
  formant_ssff = NULL,
  formant_axisLabel = "Frequency (Hz)",
  formant_highlight = NULL,
  intensity_timeStep = NULL,
  intensity_minPitch = 100,
  intensity_range = NULL,
  intensity_color = "black",
  intensity_plotOnSpec = FALSE,
  intensity_plotOnWave = FALSE,
  intensity_ssff = NULL,
  intensity_axisLabel = "Intensity (dB)",
  intensity_highlight = NULL,
  time_axisLabel = NULL,
  highlight = NULL,
  draw_lines = list("formant", h = seq(0, 10000, by = 1000), lty = "dotted"),
  draw_rectangle = NULL,
  draw_arrow = NULL,
  annotate = NULL,
  gender = "u",
  ...
)
}
\arguments{
\item{sound}{String giving the file name of a sound file with the .wav
extension.}

\item{start}{Start time (in seconds) of desired plotted area. Default is \code{0}.}

\item{end}{End time (in seconds) of desired plotted area. Default is \code{0}
(= the entire file).}

\item{tfrom0}{Logical; should time on the x-axis run from 0 or from the
original time? Default is \code{TRUE}.}

\item{tUnit}{String giving the unit of time to print along the x-axis.
Possible options are \code{'s'} (default) for seconds and \code{'ms'} for milliseconds.}

\item{frames}{String or vector of strings giving the frames that the plot
should consist of. Default is \code{sound}, \code{spectrogram}, \code{TextGrid}. This
requires a file with the extension \code{.TextGrid} and the same base name as the
sound file. Other options are \code{pitch}, \code{formant}, and \code{intensity}. See
details for more information.}

\item{proportion}{Integer or vector of integers of the same size as \code{frames}
giving the proportion in percents of the plotting area to be taken up by the
individual frames. Default is \code{c(30,50,20)}. If more or less than three
frames are plotted and no proportions are given, frames will be of equal
size.}

\item{mainTitle}{String giving a title to print at the top of the plot.
The default is an empty string, i.e. no title.}

\item{mainTitleAlignment}{Number indicating the vertical alignment of the
plot title, where \code{0} (default) indicates left-alignment, \code{1} indicates
right-alignment, \code{0.5} indicates central alignment, etc, following the
conventions of the \code{adj} argument of \link[graphics:mtext]{graphics::mtext}.}

\item{start_end_only}{Logical; should there only be ticks on the x-axis
for start and end times? Default is \code{TRUE}.}

\item{min_max_only}{Logical; should only minimum and maximum values be given
on the y-axis? Default is \code{TRUE}. Can also be a logical vector if some but
not all plot components should have minimum and maximum values on the y-axis.
Ignored for TextGrid component.}

\item{drawSize}{Number indicating the line width of plot components where
the \verb{_plotType} is \code{'draw'} (i.e., pitch, formants, or intensity rendered as
line plots). Default is \code{1}. Controls the \code{lwd} argument of
\link[graphics:lines]{graphics::lines}.}

\item{speckleSize}{Number indicating the point size of plot components where
the \verb{_plotType} is \code{'speckle'} (i.e. pitch or formants rendered as point
plots). Default is \code{1}. Controls the \code{cex} arguments of \link[graphics:points]{graphics::points}.}

\item{wave_channels}{Vector of numbers or strings giving either numeric
identifiers of audio channels to plot of the names of audio channels to plot.
Also understands \code{'all'}, which plots all channels and is the default.}

\item{wave_channelNames}{Should names of audio channels be printed
on the y-axis? If \code{TRUE}, names will be grabbed from the audio metadata if
available. Alternatively, if two channels are available, they will be named
\code{left} and \code{right}. If more or less than two channels are available,
channels are named \code{Cn}, where \code{n} is the number of the channel. Alternatvely,
a vector of strings can be provided with channel names. Default is \code{FALSE}.}

\item{wave_energyRange}{Numeric vector of length 2 giving the desired energy
range (y-axis range) of waveform(s). Default is \code{NULL}, in which case the
y-axis range is set to the lowest and highest value for each wave.}

\item{wave_axisDigits}{Numeric giving the number of digits to print for
values along the y-axis of the waveform. Default is \code{3}. If \code{0} is passed,
the y-axis is suppressed. Note that this only applies when
\code{min_max_only = TRUE}, as otherwise the look of the y-axis is determined
entirely using \code{grDevices::axisTicks()}.}

\item{wave_color}{String giving the name of the color to be used for plotting
the waveform. Default is \code{'black'}. Alternatively a vector of strings, if
different colors should be used for different channels.}

\item{wave_lineWidth}{Number giving the line width to use for plotting
the waveform. Default is \code{1}.}

\item{wave_highlight}{Named list giving parameters for differential
highlighting of the waveform based on the time domain. This list
should contain information about which parts of the plot to highlight, either
done with the \code{start} and \code{end} arguments which must be numbers or numeric
vectors, or using the \code{tier} and \code{label} arguments to highlight based on
information in a plotted TextGrid. Further contains the argument
\code{color} (string, see \code{wave_color}), and \code{background}
(a string specifying a background color).}

\item{tg_obj}{A TextGrid object returned by the \code{\link[=make_TextGrid]{make_TextGrid()}} function.}

\item{tg_file}{Path of file to be used for plotting TextGrid. Default is
\code{NULL}, in which case the function searches for a TextGrid sharing the same
base name as \code{sound} with the \code{.TextGrid} extension.}

\item{tg_tiers}{Vector of numbers or strings giving either numeric identifiers
of TextGrid tiers to plot or the names of TextGrid tiers to plot. Also
understands \code{'all'}, which plots all tiers and is the default.}

\item{tg_focusTier}{For which tier(s) should lines be shown on all
acoustic plots giving the locations of boundaries? Vector of number or
strings giving either numeric identifiers
of TextGrid tiers or the names of TextGrid tiers to plot. Default is
\code{tg_tiers[1]}, i.e. the first tier given in the \code{tg_tiers} argument.
Additionally accepts the string \code{none},
in which case no lines are shown on acoustic plots, and \code{all}, in
which case lines from all tiers are shown on acoustic plots.}

\item{tg_focusTierColor}{String or vector of strings giving the color(s) to
use for plotting focus tier lines. If multiple tiers are focused, a vector
of the same length can be passed, and the nth tier will be plotted in the
nth color. Default is \code{'black'}.}

\item{tg_focusTierLineType}{String or vector of strings giving the line
type(s) for plotting focus tier lines. If multiple tiers are focused, a
vector of the same length can be passed, and the nth tier will be plotted in
the nth line type. Default is \code{'dotted'}.}

\item{tg_tierNames}{Logical; should TextGrid tier names be printed along the
y-axis? Default is \code{TRUE}.}

\item{tg_alignment}{String giving the desired alignment of text in the
TextGrids. Default is \code{central}; other options are \code{left} and \code{right}.
Alternatively, a vector of strings if different alignments are needed.}

\item{tg_edgeLabels}{String specifying how to handle TextGrid labels in
interval tiers that fall partially before \code{start} or partially after \code{end}.
Default is \code{'keep'}, where labels are kept at the center of the interval.
Other options are \code{'center'}, where labels are recentered to the visible
part of the interval, or \code{'discard'}, where such labels are ignored.}

\item{tg_specialChar}{Logical; should Praat typesetting for special font types
such as italic, bold, and small caps be converted into corresponding
R-readable special font types. Default is \code{FALSE}, since special characters
can create unfortunate text alignment artefacts.
See https://www.fon.hum.uva.nl/praat/manual/Text_styles.html.}

\item{tg_color}{String or vector of strings giving the name of the color(s)
to be used for the text in TextGrids. Default is \code{'black'}. If a vector is
provided, different colors are used for different tiers.}

\item{tg_highlight}{Named list giving parameters for differential
highlighting of TextGrid intervals. This list
should contain information about which intervals to highlight, using the
\code{tier} and \code{label}. Further contains the argument
\code{color}, and \code{background}
(a string specifying a background color).}

\item{spec_channel}{Numeric giving the channel that should be used to
generate the spectrogram. Default is \code{1}. Generating spectrograms from
multiple channels is not currently possible with \code{praatpicture}.}

\item{spec_freqRange}{Vector of two integers giving the frequency range to be
used for plotting spectrograms. Default is \code{c(0,5000)}.}

\item{spec_windowLength}{Window length in seconds for generating spectrograms.
Default is \code{0.005}.}

\item{spec_dynamicRange}{Dynamic range in dB for generating spectrograms. The
maximum intensity minus \code{spec_dynamicRange} will all be printed in white.
Default is \code{50}.}

\item{spec_timeStep}{How many time steps should be calculated for spectrograms?
Default is \code{1000}.}

\item{spec_windowShape}{String giving the name of the window shape to be
applied to the signal when generating spectrograms. Default is \code{Gaussian};
other options are \code{square}, \code{Hamming}, \code{Bartlett}, \code{Hanning}, or \code{Blackman}.
Note that the Gaussian window function provided by the \code{phonTools} package
and used in \code{praatpicture()} does not have the same properties as the
Gaussian window function used for spectral estimation in Praat; plotting
a simple sine wave with high dynamic range will produce sidelobes in
\code{praatpicture()} but not in Praat. It's recommended to use Blackman windows
instead if you have this problem.}

\item{spec_colors}{Vector of strings giving the names of colors to be used
for plotting the spectrogram; default is \code{c('white', 'black')}. The first
value is used for plotting the lowest visible amplitude, and the last for
plotting the highest visible amplitude. Vectors with more than two color
names can be used for plotting values in between in different colors.}

\item{spec_axisLabel}{String giving the name of the label to print along the
y-axis when plotting a spectrogram. Default is \code{Frequency (Hz)}.}

\item{spec_highlight}{Named list giving parameters for differential
highlighting of the spectrogram based on the time domain. This list
should contain information about which parts of the plot to highlight, either
done with the \code{start} and \code{end} arguments which must be numbers or numeric
vectors, or using the \code{tier} and \code{label} arguments to highlight based on
information in a plotted TextGrid. Further contains the argument
\code{colors} (vector of strings, see \code{spec_colors}).}

\item{pitch_timeStep}{Measurement interval in seconds for tracking pitch.
Default is \code{NULL}, in which case the measurement interval is equal to
0.75 / \code{pitch_floor}.}

\item{pitch_floor}{Frequency in Hz; no pitch candidates considered below
this frequency. Default is \code{75}.}

\item{pitch_ceiling}{Frequency in Hz; no pitch candidates considered above
this frequency. Default is \code{600}.}

\item{pitch_plotType}{String giving the type of pitch plot to produce; default
is \code{draw} (a line plot), the only other option is \code{speckle} (a point plot).
Alternatively a vector \code{c('draw','speckle')} can be passed, in which case
both are used.}

\item{pitch_scale}{String giving the frequency scale to use when producing
pitch plots. Default is \code{hz}; other options are \code{logarithmic} (also in Hz),
\code{semitones}, \code{erb}, and \code{mel}.}

\item{pitch_freqRange}{Vector of two integers giving the frequency range to be
used for producing pitch plots. Default is \code{NULL}, in which case the pitch
range is automatically reset to \code{c(-12,30)} for the \code{semitones} scale,
\code{c(0,10)} for the \code{erb} scale, and \code{c(50,500)} for the Hz-based scales,
following Praat defaults.}

\item{pitch_semitonesRe}{Frequency in Hz giving the reference level for
converting pitch frequency to semitones. Default is \code{100}.}

\item{pitch_color}{String giving the name of the color to be used for
plotting pitch. Default is \code{'black'}. If \code{pitch_plotOnSpec=TRUE}, axes will
follow the same color scheme. Also if \code{pitch_plotOnSpec=TRUE}, a vector of
two strings can be passed, in which case the second color is used for
background highlighting.}

\item{pitch_plotOnSpec}{Boolean; should pitch be plotted on top of
spectrogram? Default is \code{FALSE}.}

\item{pitch_plotOnWave}{Boolean; should pitch be plotted on top of
waveform? Default is \code{FALSE}.}

\item{pitch_ssff}{An object of class \code{AsspDataObj} containing a pitch track.
Default is \code{NULL}.}

\item{pitch_axisLabel}{String giving the name of the label to print along the
y-axis when printing a pitch track. Default is \code{NULL}, in which case the
axis label will depend on the scale. If \code{pitch_plotOnSpec=TRUE}, this label
will be printed on the right-hand y-axis label.}

\item{pitch_highlight}{Named list giving parameters for differential
highlighting of pitch based on the time domain. This list
should contain information about which parts of the plot to highlight, either
done with the \code{start} and \code{end} arguments which must be numbers or numeric
vectors, or using the \code{tier} and \code{label} arguments to highlight based on
information in a plotted TextGrid. Further contains the optional arguments
\code{color} (string or vector of strings, see \code{pitch_color}),
\code{drawSize} or \code{speckleSize} (both numeric), and \code{background}
(a string specifying a background color).}

\item{formant_timeStep}{Measurement interval in seconds for tracking formants.
Default is \code{NULL}, in which case the measurement interval is equal to
\code{formant_windowLength} / 4.}

\item{formant_maxN}{Integer giving the maximum number of formants to track.
Default is \code{5}.}

\item{formant_windowLength}{The effective duration of the analysis window
used for tracking formants in seconds; the actual duration of the
analysis window is twice this value.}

\item{formant_dynamicRange}{Dynamic range in dB for producing formant plots.
When a formant plot of \code{formant_plotType='speckle'} is drawn, no formants are
shown in frames with intensity level \code{formant_dynamicRange} below the maximum
intensity. Default is \code{30}. If set to \code{0}, all formants are shown.}

\item{formant_freqRange}{Vector of two integers giving the frequency range to
be used for producing formant plots. Default is \code{c(0,5500)}.}

\item{formant_number}{Number of formants to plot. Default is \code{NULL}, in
which case all available formants are plotted.}

\item{formant_plotType}{String giving the type of formant plot to produce;
default is \code{speckle} (a point plot), the only other option is \code{draw} (a line
plot). Alternatively a vector \code{c('draw','speckle')} can be passed, in which
case both are used.}

\item{formant_color}{String or vector of strings giving the name(s) of
colors to be used for plotting formants. If one color is provided, all
formants will be plotted in this color. If multiple colors are provided,
different formants will be shown in different colors. Default is \code{'black'}.
If \code{formant_plotOnSpec=TRUE} and the length of this vector twice the number
of formants plotted, the first
half of strings will be used for the formants' primary colors and the second
half will be used for background highlighting. If the length of this vector
is one more than the number of formants plotted, the last string will
be used for background highlighting.}

\item{formant_plotOnSpec}{Boolean; should formants be plotted on top of
spectrogram? Default is \code{FALSE}.}

\item{formant_ssff}{An object of class \code{AsspDataObj} containing formant tracks.
Default is \code{NULL}.}

\item{formant_axisLabel}{String giving the name of the label to print along the
y-axis when plotting formants. Default is \code{Frequency (Hz)}.}

\item{formant_highlight}{Named list giving parameters for differential
highlighting of formants based on the time domain. This list
should contain information about which parts of the plot to highlight, either
done with the \code{start} and \code{end} arguments which must be numbers or numeric
vectors, or using the \code{tier} and \code{label} arguments to highlight based on
information in a plotted TextGrid. Further contains the optional arguments
\code{color} (string or vector of strings, see \code{formant_color}),
\code{drawSize} or \code{speckleSize} (both numeric), and \code{background}
(a string specifying a background color).}

\item{intensity_timeStep}{Measurement interval in seconds for tracking
intensity. Default is \code{NULL}, in which case the measurement interval is
equal to 0.8 * \code{intensity_minPitch}.}

\item{intensity_minPitch}{Lowest pitch in Hz used when calculating
intensity; default is \code{100}}

\item{intensity_range}{Vector of two integers giving the intensity range to be
used for producing intensity plots. Default is \code{NULL}, in which case the
range is simply the minimum and maximum levels in the curve.}

\item{intensity_color}{String giving the name of the color to be used for
plotting intensity. Default is \code{'black'}. If \code{intensity_plotOnSpec=TRUE},
axes will follow the same color scheme. Also if \code{intensity_plotOnSpec=TRUE},
a vector of two strings can be passed, in which case the second color is used
for background highlighting.}

\item{intensity_plotOnSpec}{Boolean; should intensity be plotted on top of
spectrogram? Default is \code{FALSE}.}

\item{intensity_plotOnWave}{Boolean; should intensity be plotted on top of
waveform? Default is \code{FALSE}.}

\item{intensity_ssff}{An object of class \code{AsspDataObj} containing intensity
tracks. Default is \code{NULL}.}

\item{intensity_axisLabel}{String giving the name of the label to print along
the y-axis when plotting intensity. Default is \code{Intensity (dB)}.
If \code{intensity_plotOnSpec=TRUE}, this label
will be printed on the right-hand y-axis label.}

\item{intensity_highlight}{Named list giving parameters for differential
highlighting of the intensity contour based on the time domain. This list
should contain information about which parts of the plot to highlight, either
done with the \code{start} and \code{end} arguments which must be numbers or numeric
vectors, or using the \code{tier} and \code{label} arguments to highlight based on
information in a plotted TextGrid. Further contains the optional arguments
\code{color} (string or vector of strings, see \code{intensity_color}) and
\code{drawSize} (integer), and \code{background}
(a string specifying a background color).}

\item{time_axisLabel}{String giving the name of the label to print along
the x-axis. Default is \code{NULL}, in which case \code{Time (s)} is printed if
\code{tUnit = 's'} and \code{Time (ms)} is printed if \code{tUnit = 'ms'}.}

\item{highlight}{Named list giving parameters for differential highlighting
of part of the plot based on the time domain. This list should contain
information about which parts of the plot to highlight, either done with the
\code{start} and \code{end} arguments which must be numbers or numeric vectors, or
using the \code{tier} and \code{label} arguments to highlight based on information in
a plotted TextGrid. Further contains the optional arguments \code{color}
(a string), \code{drawSize} and \code{speckleSize} (both numeric), and \code{background}
(a string specifying a background color). This argument is
used to highlight all plot components, use the \verb{*_highlight} arguments for
highlighting individuals plot components.}

\item{draw_lines}{Use for drawing straight lines on plot components. Takes
an argument of type \code{list} which should contain a) a string giving the plot
component to draw straight lines on, and b) arguments to pass on to
\link[graphics:abline]{graphics::abline}. Should have a named argument \code{h} for horizontal lines,
or \code{v} for vertical lines, or \code{a},\code{b} for the intercept and slope of the
line otherwise. Alternatively a nested list can be passed if more (sets of)
lines should be drawn. If multiple audio
channels are plotted and lines should be added to one of these,
use the channel identifier instead of a string giving the frame to draw on.
The default value is \code{list('formant', h=seq(0,10000,by=1000), lty='dotted')}.
According to Praat defaults, this means that if formants are plotted in a
separate frame, horizontal dotted lines (\code{lty}) are shown at 1000 Hz
intervals. To override this behavior, simply pass \code{draw_lines=NULL}.}

\item{draw_rectangle}{Use for drawing rectangles on plot components. A
vector containing a) a string giving the plot component to draw a rectangle
on, and b) arguments to pass on to \link[graphics:rect]{graphics::rect}. Alternatively a list
of such vectors, if more rectangles should be drawn. If multiple audio
channels are plotted and a rectangle should be added to one of these,
use the channel identifier instead of a string giving the frame to draw on.}

\item{draw_arrow}{Use for drawing arrows on plot components. A vector
containing a) a string giving the plot component to draw an arrow on, and
b) arguments to pass on to \link[graphics:arrows]{graphics::arrows}. Alternatively a list of
such vectors, if more arrows should be drawn. If multiple audio
channels are plotted and an arrow should be added to one of these,
use the channel identifier instead of a string giving the frame to draw on.}

\item{annotate}{Use for annotating plot components. A vector containing
a) a string giving the plot component to annotate, and
b) arguments to pass on to \link[graphics:text]{graphics::text}. Alternatively a list of
such vectors, if more annotations should be made. If multiple audio
channels are plotted and annotations should be added to one of these,
use the channel identifier instead of a string giving the frame to draw on.}

\item{gender}{String indicating the gender of the speaker; default is
\code{u} for unknown, other legal values are \code{m} and \code{f}. Used to tweak pitch
and formant tracking parameters.}

\item{...}{Further global plotting arguments passed on to \code{par()}.}
}
\value{
No return value, produces a figure.
}
\description{
Generate plots of acoustic data aligned with transcriptions similar
to those made with Praat Picture. The default is to produce a plot with a
relatively small waveform, somewhat larger spectrogram, and the first tier
of a TextGrid.
}
\details{
When available, pitch, formant, and intensity tracks are loaded
from Praat files with the same base name as \code{sound}; i.e., if your sound
file is called \verb{1.wav} and there is a Praat file called \verb{1.Formant} in the
same directory, this file is used for plotting formants. Pitch files should
have either the \code{PitchTier} or \code{Pitch} extension, and intensity files should
have the \code{IntensityTier} extension.

If no such files are available, the signal processing tools in the \code{wrassp}
package are used; pitch is tracked with the function \link[wrassp:ksvF0]{wrassp::ksvF0},
formants are tracked with \link[wrassp:forest]{wrassp::forest}, and intensity is tracked with
\link[wrassp:rmsana]{wrassp::rmsana}. Parameters are set to mimic Praat as closely as possible,
e.g. using a Gaussian-like window shape \code{KAISER2_0}, but results will differ
from Praat simply because the tracking algorithms differ; as far as I know,
the Burg algorithm used by Praat for tracking formants isn't implemented in R,
nor is the autocorrelation method for tracking pitch.

Spectrograms are generated with the function \link[phonTools:spectrogram]{phonTools::spectrogram}. The
code portion that actually adds the spectrogram to a plot is based on
\link[phonTools:spectrogram]{phonTools::plot.spectrogram} but rewritten to use a bitmap raster for
rendering the image if the graphics device allows for it, which
significantly speeds up rendering the spectrogram.
}
\examples{
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile)
}
