% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{create_usrdata}
\alias{create_usrdata}
\title{Create a user-defined test dataset}
\usage{
create_usrdata(test_type, scores = NULL, labels = NULL, tsname = NULL,
  base_x = NULL, base_y = NULL, text_x = NULL, text_y = NULL,
  text_x2 = text_x, text_y2 = text_y)
}
\arguments{
\item{test_type}{A single string to specify the type of dataset generated by
  this function.

  \describe{
    \item{"bench"}{Create a test dataset for benchmarking}
    \item{"curve"}{Create a test dataset for curve evaluation}
  }}

\item{scores}{A numeric vector to set scores.}

\item{labels}{A numeric vector to set labels.}

\item{tsname}{A single string to specify the name of the dataset.}

\item{base_x}{A numeric vector to set pre-calculated recall values for
curve evaluation.}

\item{base_y}{A numeric vector to set pre-calculated precision values for
curve evaluation.}

\item{text_x}{A single numeric value to set the x position for displaying
the test result in a plot}

\item{text_y}{A single numeric value to set the y position for displaying
the test result in a plot}

\item{text_x2}{A single numeric value to set the x position for displaying
the test result (group into categories) in a plot}

\item{text_y2}{A single numeric value to set the y position for displaying
the test result (group into categories) in a plot}
}
\value{
A list of \code{R6} test dataset objects.
}
\description{
The \code{create_usrdata} function creates various types of test datasets.
}
\examples{
## Create a test dataset for benchmarking
testset2 <- create_usrdata("bench", scores = c(0.1, 0.2), labels = c(1, 0),
                           tsname = "m1")

## Create a test dataset for curve evaluation
testset <- create_usrdata("curve", scores = c(0.1, 0.2), labels = c(1, 0),
                           base_x = c(0, 1.0), base_y = c(0, 0.5))

}
\seealso{
\code{\link{create_testset}} for creating a predefined test set.
 \code{\link{TestDataB}} for benchmarking test data.
 \code{\link{TestDataC}} for curve evaluation test data.
}

