% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pci.supraseasonal.r
\name{pci.supraseasonal}
\alias{pci.supraseasonal}
\title{Supraseasonal Precipitation Concentration Index}
\usage{
pci.supraseasonal(object, hemisthere = c("n", "s"))
}
\arguments{
\item{object}{is a daily or monthly precipitation serie.}

\item{hemisthere}{is the hemisthere, "n" for northern and "s" for south, of the precipitation serie.}
}
\value{
A data.frame containing the following variables:
\itemize{
\item \code{year} is the year;
\item \code{season} is the meteorological supraseason, wet or dry; and
\item \code{pci.season} is the seasonal perceptation concentration index.
}
}
\description{
It calculates the supraseasonal precipitation concentration index.
}
\examples{
##
# Loading the daily precipitation serie
data(daily)

##
# Calculating the supraseasonal precipitation concentration index
pci.supraseasonal(daily, hemisthere = "s")
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\references{
M. de Luis, J. C. Gonz\'alez-Hidalgo, M. Brunetti,  L. A. Longares (2011). 
Precipitation concentration changes in Spain 1946-2005. Natural Hazards and Earth System Science, 
5:11, pp. 1259--1265
}

