% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE_surv.R
\name{onearmsurv.dr}
\alias{onearmsurv.dr}
\title{Doubly robust estimators of the coefficients in the two regression}
\usage{
onearmsurv.dr(ynew, dnew, trt, x.cate, tau0, weightsurv, ps, f.predictor)
}
\arguments{
\item{ynew}{Truncated survival or censoring time; vector of size \code{n}.}

\item{dnew}{The event indicator after truncation, \code{1 = event or censored after truncation, 0 = censored before truncation};
vector of size \code{n}.}

\item{trt}{Treatment received; vector of size \code{n} with treatment coded as 0/1.}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates specified in the outcome model; dimension \code{n} by \code{p.cate}.}

\item{tau0}{The truncation time for defining restricted mean time lost.}

\item{weightsurv}{Estimated inverse probability of censoring weights with truncation for all observations; vector of size \code{n}.}

\item{ps}{Estimated propensity scores for all observations; vector of size \code{n}}

\item{f.predictor}{Initial prediction of the outcome (restricted mean time loss) conditioned on the covariates \code{x.cate} for one treatment group \code{r};
\code{mu_r(x.cate)}, step 1 in the two regression; vector of size \code{n}}
}
\value{
Doubly robust estimators of the two regression coefficients \code{beta_r} where \code{r = 0, 1} is treatment received; vector of size \code{p.cate} + 1 (intercept included)
}
\description{
Doubly robust estimators of the coefficients in the two regression
}
