% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_mlogit.R
\name{mlogit}
\alias{mlogit}
\title{Multinomial Logistic Regression}
\usage{
mlogit(Y, X, beta = NULL, add.intercept = FALSE, betaOnly = FALSE,
  tol.zero = 1e-08, verbose = T, suppressFittedWarning = FALSE,
  maxNR.print.level = 0, iterlim = 150, checkY = TRUE)
}
\arguments{
\item{Y}{A matrix of the outcomes, with K columns for 
the K groups.  Row sums of the matrix should be equal
to one, but entries do not have to be 0/1 (but they
should be positive). i.e. this is a matrix of hard or
soft assignments to K categories. The first column is
used as the reference category.}

\item{X}{matrix of covariates for regression. Should have
the same number of rows (observations) as Y. Coefficients
for all parameters in X are computed for K-1 groups. 
The coefficients  corresponding to the first column of Y
are assumed to be zero.}

\item{beta}{starting values for the optimziation.  Should be
given as a matrix of column vectors, each vector a
different starting value.  If null, defaults to zeros.}

\item{add.intercept}{a logical indicator of whether an
intercept column should be added to X}

\item{betaOnly}{logical indicator of whether only the
parameter estimates beta should be returned. Otherwise,
beta is returned along with fitted objects. See Output.}

\item{tol.zero}{the tolerance threshold for considering a
fitted value as equal to zero.  Used for warning about
fitted values of 0/1.  Is NOT part of the optimization
control parameters.}

\item{verbose}{logical indicator that controls whether text
indicating progress is output to display}

\item{suppressFittedWarning}{indicator of whether or not
warnings about fitted values of 1 are returned}

\item{maxNR.print.level}{numeric value giving the level of
output produced by maxNR.  see \code{?maxNR} for details.
Defaults to 0.}

\item{iterlim}{iteration limit for maxNR. Defaults to 150.}

\item{checkY}{indicator for whether Y should be checked to be a valid assignment matrix.  Set to \code{FALSE} if using decimal values in Y.}
}
\value{
A list containing the following:

\item{beta}{ a p x K matrix of parameter estimates corresponding to the K columns of Y and p covariates in X}
 \item{fitted01}{indicator of whether fitted values of 1 were present.}
 \item{fitted}{the fitted probabilities}
 \item{res.best}{ the best result from the maxNR fit}
	\item{status}{ small data frame summarizing the status of the fits}
  \item{res. all}{ a list containing the results from all maxNR fits}
}
\description{
Solves a multinomial logistic problem using 
	Newton-Raphson method
}
\details{
The optimization is done using the \code{\link{maxNR}} function from the \code{maxLik} package.  The log-likehood function, along with its gradient and hessian, are implemented as C++ functions (via the \code{RcppArmadillo} package).
}
\examples{
n <- 2000
X <- cbind(1,
           matrix(rnorm(2*n), nrow=n, ncol=2),
           rbinom(n, size=1, prob=0.3))
beta <- cbind(rep(0, 4),
              c(0.5, 1, 0, -1),
              c(0, 2, 2, 0))
probs <- exp(X \%*\% beta)
probs <- probs/rowSums(probs)
Y <- t(apply(probs, 1, function(p) rmultinom(1, 1, p)))
mfit <- mlogit(Y=Y, X=X, betaOnly=TRUE)
mfit
}
\seealso{
\code{\link{predkmeans}}
}
\author{
Joshua Keller
}
