% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_create.R
\name{form_create}
\alias{form_create}
\title{Create a new (pre)registration form}
\usage{
form_create(
  title,
  version,
  author = NA,
  date = format(Sys.Date(), "\%Y-\%m-\%d"),
  ...
)
}
\arguments{
\item{title}{The form's title}

\item{version}{The form's version. If there is only one version and the
creators do not plan to release future version, the recommendation is to
set the version to \code{1}. If the creators have no clear idea about how to
version the form (i.e. there may be improvements in the future), the
recommendation is to set the first version to \verb{0.0.1}, and roughly adopt
the system common for software: increment the first number when the form
is substantially updated (e.g. such that preregistrations that used the
previous version of the form may no longer be valid given the new version,
for example becaue sections were added or removed, or value templates
changed, etc), the third number for very small changes (e.g. typos,
spelling corrections, clarification or extra explanations, bug fixes in
regular expressions in value templates, etc), and the second number for
changes in between (e.g. changing the order of items or moving an item
to another section, or changing value templates to be more permissive (and
so, retaining compatibility with (pre)registrations that used the previous
version of the form)). In that case, use version \verb{1.0.0} to signal that the
form has reached maturity.}

\item{author}{The authors of the form}

\item{date}{The date the form was created}

\item{...}{Additional field-content pairs to specify arbitrary metadata.}
}
\value{
The \code{preregr} form object prefilled with some examples.
}
\description{
You can use this function to create a new (pre)registration form.
The "Creating a (pre)registration form" vignette explains how this works.
That is available at
\url{https://r-packages.gitlab.io/preregr/articles/creating_prereg_form.html}
or can be shown by running \code{vignette("creating_prereg_form",
package = "preregr")}.
}
\examples{
exampleForm <-
  preregr::form_create(
    title = "Example form",
    version = "0.1.0"
  );

### Show the form summary
exampleForm;
}
