% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_gurobi_solver.R
\name{add_gurobi_solver}
\alias{add_gurobi_solver}
\alias{add_gurobi_solver}
\title{Add a Gurobi solver}
\usage{
add_gurobi_solver(x, gap = 0.1, time_limit = .Machine$integer.max,
  presolve = 2, threads = 1, first_feasible = 0, verbose = TRUE)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{gap}{\code{numeric} gap to optimality. This gap is relative when
solving problems using \code{gurobi}, and will cause the optimizer to
terminate when the difference between the upper and lower objective
function bounds is less than the gap times the upper bound. For example, a
value of 0.01 will result in the optimizer stopping when the difference
between the bounds is 1 percent of the upper bound. But for other solvers
(e.g. \code{Rsymhpony}), this gap is absolute and expresses the acceptable
deviance from the optimal objective. For example, solving a
minimum set objective problem with a gap of 5 will cause the solver
to terminate when the cost of the solution is within 5 cost units
from the optimal solution.}

\item{time_limit}{\code{numeric} time limit in seconds to run the optimizer.
The solver will return the current best solution when this time limit is
exceeded.}

\item{presolve}{\code{integer} number indicating how intensively the
solver should try to simplify the problem before solving it. The default
value of 2 indicates to that the solver should be very aggressive in
trying to simplify the problem.}

\item{threads}{\code{integer} number of threads to use for the
optimization algorithm. The default value of 1 will result in only
one thread being used.}

\item{first_feasible}{\code{logical} should the first feasible solution be
be returned? If \code{first_feasible} is set to \code{TRUE}, the solver
will return the first solution it encounters that meets all the
constraints, regardless of solution quality. Note that the first feasible
solution is not an arbitrary solution, rather it is derived from the
relaxed solution, and is therefore often reasonably close to optimality.
Defaults to \code{FALSE}.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems?}
}
\description{
Specify the use of a Gurobi algorithm to solve a
\code{\link{ConservationProblem-class}} object. Requires the \code{gurobi}
package.
}
\details{
\href{http://gurobi.com}{Gurobi} is a
    state-of-the-art commercial optimization software with an R package
    interface. It is by far the fastest of the solvers available in this
    package, however, it is also the only solver that is not freely
    available. That said, licenses are available to academics at no cost. The
    \code{gurobi} package is distributed with the Gurobi software suite.
    This solver uses the \code{gurobi} package to solve problems.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.1) \%>\%
  add_binary_decisions()
\donttest{
# if the package is installed then add solver and generate solution
if (requireNamespace("gurobi", quietly = TRUE)) {
  # specify solver and generate solution
  s <- p \%>\% add_gurobi_solver(gap = 0.1, presolve = 2, time_limit = 5) \%>\%
             solve()

  # plot solutions
  plot(stack(sim_pu_raster, s), main = c("planning units", "solution"),
       axes = FALSE, box = FALSE)
}
}
}
\seealso{
\code{\link{solvers}}.
}
