% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{scalar_parameters}
\alias{scalar_parameters}
\alias{proportion_parameter}
\alias{binary_parameter}
\alias{integer_parameter}
\alias{numeric_parameter}
\title{Scalar parameters}
\usage{
proportion_parameter(name, value)

binary_parameter(name, value)

integer_parameter(name, value,
  lower_limit = as.integer(-.Machine$integer.max),
  upper_limit = as.integer(.Machine$integer.max))

numeric_parameter(name, value, lower_limit = .Machine$double.xmin,
  upper_limit = .Machine$double.xmax)
}
\arguments{
\item{name}{\code{character} name of parameter.}

\item{value}{\code{integer} or \code{double} value depending on the
parameter.}

\item{lower_limit}{\code{integer} or \code{double} value representing
the smallest acceptable value for \code{value}. Defaults to
the smallest possible number on the system.}

\item{upper_limit}{\code{integer} or \code{double} value representing
the largest acceptable value for \code{value}. Defaults to
the largest possible number on the system.}
}
\value{
\code{\link{ScalarParameter-class}} object.
}
\description{
These functions are used to create parameters that consist of a single
number. Parameters have a name, a value, a defined range of acceptable
values, a default value, a class, and a \code{\link[shiny]{shiny}} widget for
modifying them. If values are supplied to a parameter that are unacceptable
then an error is thrown.
}
\details{
Below is a list of parameter generating functions and a brief
  description of each.

\describe{

  \item{proportion_parameter}{A parameter that is a \code{double} and bounded
    between zero and one.}

  \item{integer_parameter}{A parameter that is a \code{integer}.}

  \item{numeric_parameter}{A parameter that is a \code{double}.}

\item{binary_parameter}{A parameter that is restricted to \code{integer}
  values of zero or one.}
}
}
\examples{
# proportion parameter
p1 <- proportion_parameter('prop', 0.5) # create new object
print(p1) # print it
p1$get() # get value
p1$id # get id
p1$validate(5) # check if 5 is a validate input
p1$validate(0.1) # check if 0.1 is a validate input
p1$set(0.1) # change value to 0.1
print(p1)

# binary parameter
p2 <- binary_parameter('bin', 0) # create new object
print(p2) # print it
p2$get() # get value
p2$id # get id
p2$validate(5) # check if 5 is a validate input
p2$validate(1L) # check if 1L is a validate input
p2$set(1L) # change value to 1L
print(p1) # print it again

# integer parameter
p3 <- integer_parameter('int', 5L) # create new object
print(p3) # print it
p3$get() # get value
p3$id # get id
p3$validate(5.6) # check if 5.6 is a validate input
p3$validate(2L) # check if 2L is a validate input
p3$set(2L) # change value to 2L
print(p3) # print it again

# numeric parameter
p4 <- numeric_parameter('dbl', -7.6) # create new object
print(p4) # print it
p4$get() # get value
p4$id # get id
p4$validate(NA) # check if NA is a validate input
p4$validate(8.9) # check if 8.9 is a validate input
p4$set(8.9) # change value to 8.9
print(p4) # print it again

# numeric parameter with lower bounds
p5 <- numeric_parameter('bdbl', 6, lower_limit=0) # create new object
print(p5) # print it
p5$get() # get value
p5$id # get id
p5$validate(-10) # check if -10 is a validate input
p5$validate(90) # check if 90 is a validate input
p5$set(90) # change value to 8.9
print(p5) # print it again

}
