% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pproto.R
\name{pproto}
\alias{pproto}
\title{Create a new \code{pproto} object}
\usage{
pproto(`_class` = NULL, `_inherit` = NULL, ...)
}
\arguments{
\item{_class}{Class name to assign to the object. This is stored as the class
attribute of the object. This is optional: if \code{NULL} (the default),
no class name will be added to the object.}

\item{_inherit}{\code{ggproto} object to inherit from. If \code{NULL}, don"t
inherit from any object.}

\item{...}{A list of members to add to the new \code{pproto} object.}
}
\description{
Construct a new object with \code{pproto}. This object system is inspired
from the \code{ggproto} system used in the \code{ggplot2} package.
}
\examples{
Adder <- pproto("Adder",
  x = 0,
  add = function(self, n) {
    self$x <- self$x + n
    self$x
  }
)

Adder$add(10)
Adder$add(10)

Abacus <- pproto("Abacus", Adder,
  subtract = function(self, n) {
    self$x <- self$x - n
    self$x
  }
)
Abacus$add(10)
Abacus$subtract(10)

}
