% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cbc_solver.R
\name{add_cbc_solver}
\alias{add_cbc_solver}
\title{Add a \emph{CBC} solver}
\usage{
add_cbc_solver(
  x,
  gap = 0.1,
  time_limit = .Machine$integer.max,
  presolve = TRUE,
  threads = 1,
  first_feasible = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}) object.}

\item{gap}{\code{numeric} gap to optimality. This gap is relative
and expresses the acceptable deviance from the optimal objective.
For example, a value of 0.01 will result in the solver stopping when
it has found a solution within 1\% of optimality.
Additionally, a value of 0 will result in the solver stopping
when it has found an optimal solution.
The default value is 0.1 (i.e. 10\% from optimality).}

\item{time_limit}{\code{numeric} time limit (seconds) for generating solutions.
The solver will return the current best solution when this time limit is
exceeded. The default value is the largest integer value
(i.e. \code{.Machine$integer.max}), effectively meaning that solver
will keep running until a solution within the optimality gap is found.}

\item{presolve}{\code{logical} attempt to simplify the
problem before solving it? Defaults to \code{TRUE}.}

\item{threads}{\code{integer} number of threads to use for the
optimization algorithm. The default value is 1.}

\item{first_feasible}{\code{logical} should the first feasible solution be
be returned? If \code{first_feasible} is set to \code{TRUE}, the solver
will return the first solution it encounters that meets all the
constraints, regardless of solution quality. Note that the first feasible
solution is not an arbitrary solution, rather it is derived from the
relaxed solution, and is therefore often reasonably close to optimality.
Defaults to \code{FALSE}.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems? Defaults to \code{TRUE}.}
}
\value{
Object (i.e. \code{\linkS4class{ConservationProblem}}) with the solver
added to it.
}
\description{
Specify that the \href{https://projects.coin-or.org/Cbc}{\emph{CBC}}
(COIN-OR branch and cut) software (Forrest &
Lougee-Heimer 2005) should be used to solve a conservation planning
\code{\link[=problem]{problem()}}.
This function can also be used to customize the behavior of the solver.
It requires the \pkg{rcbc} package to be installed
(only \href{https://github.com/dirkschumacher/rcbc}{available on GitHub},
see below for installation instructions).
}
\details{
\href{https://projects.coin-or.org/Cbc}{\emph{CBC}} is an
open-source mixed integer programming solver that is part of the
Computational Infrastructure for Operations Research (COIN-OR) project.
Although formal benchmarks examining the performance of this solver for
conservation planning problems have yet to be completed, preliminary
analyses suggest that it performs much faster than the other open-source
solvers (i.e. \code{\link[=add_rsymphony_solver]{add_rsymphony_solver()}}, \code{\link[=add_rsymphony_solver]{add_rsymphony_solver()}}), and
so we recommend using this solver if the \emph{Gurobi} and \emph{IBM CPLEX} solvers
are unavailable.
}
\section{Installation}{

The \pkg{rcbc} package is required to use this solver. Since the
\pkg{rcbc} package is not available on the
the Comprehensive R Archive Network (CRAN), it must be installed from
\href{https://github.com/dirkschumacher/rcbc}{its GitHub repository}. To
install the \pkg{rcbc} package, please use the following code:\preformatted{if (!require(remotes)) install.packages("remotes")
remotes::install_github("dirkschumacher/rcbc")
}

Note that you may also need to install several dependencies --
such as the
\href{https://cran.r-project.org/bin/windows/Rtools/}{Rtools software}
or system libraries -- prior to installing the \pkg{rcbc} package.
For further details on installing this package, please consult
\href{https://dirkschumacher.github.io/rcbc/}{official installation instructions for the package}.
}

\examples{
\dontrun{
# load data
data(sim_pu_raster, sim_features)

# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.1) \%>\%
  add_binary_decisions() \%>\%
  add_cbc_solver(gap = 0.1, verbose = FALSE)

# generate solution \%>\%
s <- solve(p)

# plot solution
plot(s, main = "solution", axes = FALSE, box = FALSE)
}
}
\references{
Forrest J and Lougee-Heimer R (2005) CBC User Guide. In Emerging theory,
Methods, and Applications (pp. 257--277). INFORMS, Catonsville, MD.
\doi{10.1287/educ.1053.0020}.
}
\seealso{
\link{solvers}.
}
