% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category_layer.R
\name{category_layer}
\alias{category_layer}
\title{Category layer}
\usage{
category_layer(x)
}
\arguments{
\item{x}{\code{\linkS4class{Raster}} object containing a multiple
layers. Note that pixels must be 0, 1 or \code{NA} values.}
}
\value{
\code{\linkS4class{RasterLayer}} object.
}
\description{
Convert a \code{\linkS4class{RasterStack}}
object where each layer corresponds to a different identifier and values
indicate the presence/absence of that category into a
\code{\linkS4class{RasterLayer}} object containing categorical
identifiers.
}
\details{
This function is provided to help manage data that encompass
multiple management zones. For instance, this function may be helpful
for interpreting solutions for problems associated with multiple zones that
have binary decisions.
}
\examples{
# create a binary raster stack
x <- stack(raster(matrix(c(1, 0, 0, 1, NA, 0), nrow = 3)),
           raster(matrix(c(0, 1, 0, 0, NA, 0), nrow = 3)),
           raster(matrix(c(0, 0, 1, 0, NA, 1), nrow = 3)))

# convert to binary stack
y <- category_layer(x)

# plot categorical raster and binary stack representation
\dontrun{
plot(stack(x, y), main = c("x[[1]]", "x[[2]]", "x[[3]]", "y"), nr = 1)
}
}
\seealso{
\code{\link[=binary_stack]{binary_stack()}}.
}
