% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prism_set_dl_dir.R
\name{prism_set_dl_dir}
\alias{prism_set_dl_dir}
\alias{prism_get_dl_dir}
\alias{prism_check_dl_dir}
\alias{path_check}
\title{Set, check, and get prism download directory}
\usage{
prism_set_dl_dir(path, create = TRUE)

prism_get_dl_dir()

prism_check_dl_dir()

path_check()
}
\arguments{
\item{path}{The path that prism data will be unzipped into.}

\item{create}{Boolean that determines if the \code{path} will be created if it
does not already exist.}
}
\description{
\code{prism_set_dl_dir()} sets the directory that downloaded prism data will be
saved to. The prism download directory is saved in the "prism.path" option.

\code{prism_get_dl_dir()} gets the folder that prism data will be saved to. It is
a wrapper around \code{getOption("prism.path")} so the user does not have to
remember the option name.

\code{prism_check_dl_dir()} checks that prism download folder has been set. If it
has not been set, and in interactive mode, then prompt user to specify the
download location. If not in interactive mode, and it has not been set, then
set to "~/prismtmp".

\code{path_check()} is a deprecated version of \code{prism_check_dl_dir()}.
}
