% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{response}
\alias{response}
\title{Response}
\usage{
response(activity_a, activity_b)
}
\arguments{
\item{activity_a}{\code{\link{character}}: Activity A. This should be an activity of the log supplied to \code{\link{check_rule}}.}

\item{activity_b}{\code{\link{character}}: Activity B. This should be an activity of the log supplied to \code{\link{check_rule}}.}
}
\description{
Check for response between two activities.

If \code{activity_a} is executed, it should be (eventually) followed by \code{activity_b}. The \code{response} relation is very relaxed,
because \code{B} does not have to be executed immediately after \code{A}, and multiple \code{A}s can be executed between the first \code{A}
and the subsequent \code{B}. For example, the trace \verb{[B,A,A,A,C,B]} satisfies the \code{response} relation.
}
\examples{
library(bupaR)
library(eventdataR)

# A blood test should eventually be followed by Discuss Results.
patients \%>\%
 check_rule(response("Blood test","Discuss Results"))

}
\seealso{
Other Ordering rules: 
\code{\link{ends}()},
\code{\link{precedence}()},
\code{\link{responded_existence}()},
\code{\link{starts}()},
\code{\link{succession}()}
}
\concept{Ordering rules}
