% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{penalty}
\alias{penalty}
\title{B-Spline penalty}
\usage{
penalty(knots, order, max_diff = 999L)
}
\arguments{
\item{knots}{Vector of knots.}

\item{order}{Order of the Basis (degree + 1).}

\item{max_diff}{Maximum difference order to calculate.}
}
\value{
Returns a list of (order - 1) penalty matrices.
}
\description{
This function calculates the B-Spline basis penalty.
It follows the procedure outlined in the paper by Zheyuan Li, Jiguo
Cao, 2022 "General P-Splines for Non-Uniform B-Splines"
\doi{10.48550/arXiv.2201.06808}.
For equidistant knots it coincides with the usual penalty based
on the identitiy. For non-equidistant knots it is a weighted penalty
with respect to the knot distances.
}
\examples{
\dontrun{
# Equidisan knots with order 2
knots <- 1:10

P <- penalty(knots, order = 2)

print(P[[1]]) # First differences

# Non-equidistant knots
knots <- c(0, 0, 0, 0, 1, 3, 4, 4, 4, 4)

P <- penalty(knots, order = 4)

print(P[[1]]) # First differences
print(P[[2]]) # Second differences
print(P[[3]]) # Third differences
}

}
