% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_progress.R, R/without_progress.R
\name{with_progress}
\alias{with_progress}
\alias{without_progress}
\title{Report on Progress while Evaluating an R Expression}
\usage{
with_progress(
  expr,
  handlers = progressr::handlers(),
  cleanup = TRUE,
  delay_stdout = getOption("progressr.delay_stdout", interactive()),
  delay_conditions = getOption("progressr.delay_conditions", if (interactive())
    c("condition") else character(0L)),
  interval = NULL,
  enable = NULL
)

without_progress(expr)
}
\arguments{
\item{expr}{An \R expression to evaluate.}

\item{handlers}{A progression handler or a list of them.
If NULL or an empty list, progress updates are ignored.}

\item{cleanup}{If TRUE, all progression handlers will be shutdown
at the end regardless of the progression is complete or not.}

\item{delay_stdout}{If TRUE, standard output is captured and relayed
at the end just before any captured conditions are relayed.}

\item{delay_conditions}{A character vector specifying \link[base:condition]{base::condition}
classes to be captured and relayed at the end after any captured
standard output is relayed.}

\item{interval}{(numeric) The minimum time (in seconds) between
successive progression updates from handlers.}

\item{enable}{(logical) If FALSE, then progress is not reported.}
}
\value{
Return nothing (reserved for future usage).
}
\description{
Report on Progress while Evaluating an R Expression
}
\details{
\emph{IMPORTANT: This function is meant for end users only.  It should not
be used by R packages, which only task is to \emph{signal} progress updates,
not to decide if, when, and how progress should be reported.}

\code{without_progress()} evaluates an expression while ignoring all
progress updates.
}
\section{Progression handler functions}{

Formally, progression handlers are calling handlers that are called
when a \link{progression} condition is signaled.  These handlers are functions
that takes one argument which is the \link{progression} condition.
}

\examples{
## The slow_sum() example function
slow_sum <- progressr::slow_sum
print(slow_sum)

x <- 1:10

## Without progress updates
y <- slow_sum(x)


## Progress reported via txtProgressBar (default)
handlers("txtprogressbar")  ## default
with_progress({
  y <- slow_sum(x)
})

## Progress reported via tcltk::tkProgressBar
if (capabilities("tcltk") && requireNamespace("tcltk", quietly = TRUE)) {
  handlers("tkprogressbar")
  with_progress({
    y <- slow_sum(x)
  })
}

## Progress reported via progress::progress_bar)
if (requireNamespace("progress", quietly = TRUE)) {
  handlers("progress")
  with_progress({
    y <- slow_sum(x)
  })
}

## Progress reported via txtProgressBar and beepr::beep
if (requireNamespace("beepr", quietly = TRUE)) {
  handlers("beepr", "txtprogressbar")
  with_progress({
    y <- slow_sum(x)
  })
}

## Progress reported via customized utils::txtProgressBar and beepr::beep,
## if available.
handlers(handler_txtprogressbar(style = 3L))
if (requireNamespace("beepr", quietly = TRUE)) {
  handlers("beepr", append = TRUE)
}

with_progress({
  y <- slow_sum(1:30)
})
}
\seealso{
\code{\link[base:withCallingHandlers]{base::withCallingHandlers()}}
}
