% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_path.R
\name{network_diagram}
\alias{network_diagram}
\title{Creates a network diagram of tasks in a project.}
\usage{
network_diagram(df, use_name_as_label = FALSE)
}
\arguments{
\item{df}{Task input. This can either be a data frame of raw data
(i.e not from the 'critical_path' function) or can the return value from calling
the 'critical path' function.
If the data is raw, if must have columns "ID, name, duration, dependencies"
in that order. These columns need not be named but they must be in that order.
Type 'taskdata1' into the console for an example of raw data.}

\item{use_name_as_label}{Boolean specifying whether to use the task name
as the label for the network diagram. The default is to use the task ID.}
}
\value{
A network diagram for the tasks. If data has been processed by the critical path function,
then this network diagram will color the critical path elements.
}
\description{
Creates a network diagram of tasks in a project.
}
\examples{
# Use raw example data
data <- taskdata1
# Create a network diagram chart using the raw data
network_diagram(data)

res <- critical_path(data)

# Create a second network diagram using the processed data
network_diagram(res)

}
