% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_todo}
\alias{report_todo}
\title{Print to-do lists in RMarkdown friendly way}
\usage{
report_todo(todo, show_ratio = TRUE)
}
\arguments{
\item{todo}{List of to-do list, as returned by \code{read_todo()}}

\item{show_ratio}{Boolean. Whether or not to report (# Closed Items / # Total Items) for each group as a ratio}
}
\value{
Returns character string of HTML with class attribute to be correctly
shown "as-is" in RMarkdown
}
\description{
Interprets list representation of to-do list, using HTML to format results in a highly readable and
attractive way. Resulting object returned is a character vector of HTML code with the added
class of \code{'knit_asis'} so that when included in an RMarkdown document knitting to HTML,
the results will be correctly rendered as HTML.
}
\details{
The resulting HTML unordered list (\verb{<ul>}) is tagged with class 'report_todo' for custom CSS styling.
}
\examples{
\dontrun{
# the following could be run in RMarkdown
todo_path <- system.file("extdata", "todo-ex.yml", package = "projmgr", mustWork = TRUE)
my_todo <- read_todo(todo_path)
report_todo(my_todo)
}
}
\seealso{
Other plans and todos: 
\code{\link{post_plan}()},
\code{\link{post_todo}()},
\code{\link{read_plan}()},
\code{\link{read_todo}()},
\code{\link{report_plan}()},
\code{\link{template_yaml}()}
}
\concept{plans and todos}
