#' Create a projoint_results Object
#'
#' Internal constructor for \code{projoint_results} objects.  
#' A \code{projoint_results} stores the outputs of a conjoint analysis,
#' including estimated effects and metadata about the analysis settings.
#' It is normally generated by \code{\link{projoint}} and not called directly.
#'
#' @param ... Named elements, typically including:
#'   \itemize{
#'     \item \code{estimates}: A data frame of estimated effects (point estimates,
#'       standard errors, confidence intervals).
#'     \item \code{labels}: Attribute/level label mappings from the design.
#'     \item \code{structure}: Either \code{"profile_level"} or \code{"choice_level"}.
#'     \item \code{estimand}: Either \code{"mm"} (marginal mean) or
#'       \code{"amce"} (average marginal component effect).
#'     \item \code{irr}: Intra-respondent reliability value used.
#'     \item \code{tau}: Estimated \eqn{\tau} value from IRR correction.
#'     \item \code{se_method}: Method used for standard errors.
#'   }
#'
#' @return A list with class \code{"projoint_results"} containing
#'   estimates and associated metadata. This object is the standard
#'   output of \code{\link{projoint}} and is accepted by plotting
#'   and summary methods.
#'
#' @keywords internal
projoint_results <- function(...) {
  structure(
    list(...),
    class = "projoint_results"
  )
}
