% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handleTechReps.R
\name{aver_techreps}
\alias{aver_techreps}
\title{Compute average intensity}
\usage{
aver_techreps(raw_df)
}
\arguments{
\item{raw_df}{A \code{raw_df} object containing technical replicates.}
}
\value{
A \code{raw_df} object of averaged intensities.
}
\description{
This function computes average intensities across
technical replicates for each sample.
}
\details{
\code{aver_techreps} assumes that column names in the data frame
follow the "Group_UniqueSampleID_TechnicalReplicate" notation. (Use
\code{head(raw_df)} to see the structure of the \code{raw_df} object.)
}
\examples{
## Use a data set containing technical replicates to create a raw_df object
raw_df <- create_df(
prot_groups = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/pg2.txt",
exp_design = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/ed2.txt",
tech_reps = TRUE
)

# Compute average intensities across technical replicates.
rawdf_ave <- aver_techreps(raw_df)

}
\seealso{
\itemize{\item\code{\link[limma]{avearrays}} from \code{\link[limma]{limma}}
package.\item \code{\link{create_df}}
}
}
\author{
Chathurani Ranathunge
}
