% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promotion_impact.R
\name{compareModels}
\alias{compareModels}
\title{compare several models}
\usage{
compareModels(data, promotion, fix = list(logged = TRUE, differencing =
  TRUE), time.field = "dt", target.field = "sales",
  dummy.field = NULL, trend.param = 0.05, period.param = 3,
  var.type = "smooth", smooth.except.date = NULL,
  smooth.bandwidth = 2, smooth.var.sum = TRUE, allow.missing = TRUE)
}
\arguments{
\item{data}{Dataframe containing date, target variable, and some additional time dummies that the researcher wants to account for.}

\item{promotion}{Dataframe containing promotion ID, start date, end date, promotion tag(type). Might include daily payments associated with the promotion.}

\item{fix}{A List of constraints to find the best model. Constraints can only be in following list: 'period','trend','logged','synergy.var','differencing','smooth.origin','structural.change','synergy.promotion'}

\item{time.field}{Specify the date field of 'data'.}

\item{target.field}{Specify the target field of 'data'.}

\item{dummy.field}{Specify the additional time dummies of 'data'.}

\item{trend.param}{Flexibility of trend component. Default is 0.05, and as this value becomes larger, the trend component will be more flexible.}

\item{period.param}{Flexibility of period component. Default is 3, and as this value becomes larger, the period component will be more flexible.}

\item{var.type}{'smooth' to use smoothed promotion variables, 'dummy' to use dummy promotion variables}

\item{smooth.except.date}{Date value that will be excluded from the smoothing process. eg) '01' to exclude every start day of a month}

\item{smooth.bandwidth}{Bandwidth of local polynomial regression used in the smoothing process. Default value is 2.}

\item{smooth.var.sum}{If TRUE, the smoothing values for times when multiple promotions in a single tag overlap will be the values from the latest promotion. Otherwise, the values will be added(default).}

\item{allow.missing}{TRUE to allow missing data in promotion sales during the promotion period}
}
\description{
compareModels
}
\details{
compareModels compares several models under user-defined conditions and suggests the best options.
}
\examples{
\dontshow{
sim.data.sub <- sim.data \%>\% filter(dt <= '2015-05-01')
sim.promotion.sub <- sim.promotion \%>\% filter(start_dt <= '2015-05-01')
pri1 <- promotionImpact(data=sim.data.sub, promotion=sim.promotion.sub, 
                       time.field = 'dt', target.field = 'simulated_sales', 
                       trend = FALSE, period = NULL, structural.change = FALSE,
                       logged = TRUE, differencing = TRUE, synergy.promotion = FALSE,
                       synergy.var = NULL, allow.missing = TRUE)
}
\donttest{
comparison <- compareModels(data = sim.data, promotion = sim.promotion.sales,
                            fix = list(logged = T, differencing = T, smooth.origin='all',
                                       trend = FALSE, period = NULL), 
                            time.field = 'dt', target.field = 'simulated_sales', 
                            trend.param = 0.02, period.param = 2)
} 
}
