% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/622.Poster_Predictive_x.R
\name{probPREx}
\alias{probPREx}
\title{The Predicted probability - Bayesian approach}
\usage{
probPREx(x, n, xnew, m, a1, a2)
}
\arguments{
\item{x}{- Number of successes}

\item{n}{- Number of trials from data}

\item{xnew}{- Required size of number of success}

\item{m}{- Future :Number of trials}

\item{a1}{- Beta Prior Parameters for Bayesian estimation}

\item{a2}{- Beta Prior Parameters for Bayesian estimation}
}
\value{
A dataframe with x,n,xnew,m,preprb
 \item{x}{ Number of successes}
 \item{n}{ Number of trials}
 \item{xnew}{ Required size of number of success}
 \item{m}{ Future - success, trails}
 \item{preprb }{ The predicted probability}
}
\description{
The Predicted probability - Bayesian approach
}
\details{
Computes posterior predictive probability for the required size of number of
successes  for \code{xnew} of \code{m} trials from the given number of successes \code{x}
 of \code{n} trials for the given parameters for Beta prior distribution
}
\examples{
x=0; n=1; xnew=10; m=10; a1=1; a2=1
probPREx(x,n,xnew,m,a1,a2)
}
\references{
[1] 2002 Gelman A, Carlin  JB, Stern HS and Dunson DB
Bayesian Data Analysis, Chapman & Hall/CRC
}
\seealso{
Other Miscellaneous  functions for Bayesian method: \code{\link{empericalBAx}},
  \code{\link{empericalBA}}, \code{\link{probPOSx}},
  \code{\link{probPOS}}, \code{\link{probPRE}}
}

