% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/521.Error-Failure_Limitbased_CC_All.R
\name{errCAll}
\alias{errCAll}
\title{Calculates error, long term power and pass/fail criteria using 5 continuity corrected methods (Wald, Wald-T, Score, Logit-Wald, ArcSine)}
\usage{
errCAll(n, alp, phi, c, f)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{phi}{- Null hypothesis value}

\item{c}{- Continuity correction}

\item{f}{- Failure criterion}
}
\value{
A dataframe with
 \item{delalp}{ Delta-alpha is the increase of the nominal error with respect to real error}
 \item{theta}{ Long term power of the test}
 \item{Fail_Pass}{Fail/pass based on the input f criterion}
 \item{method}{Name of the method}
}
\description{
Calculates error, long term power and pass/fail criteria using 5 continuity corrected methods (Wald, Wald-T, Score, Logit-Wald, ArcSine)
}
\details{
Calculates error, long term power and pass/fail criteria using 5
continuity corrected methods (Wald, Wald-T, Score, Logit-Wald, ArcSine)
}
\examples{
n=5; alp=0.05; phi=0.05;c=1/(2*n); f=-2
errCAll(n,alp,phi,c,f)
}
\references{
[1] 2014 Martin Andres, A. and Alvarez Hernandez, M.
Two-tailed asymptotic inferences for a proportion.
Journal of Applied Statistics, 41, 7, 1516-1529
}
\seealso{
Other Error for continuity corrected methods: \code{\link{PloterrCAS}},
  \code{\link{PloterrCAll}}, \code{\link{PloterrCLT}},
  \code{\link{PloterrCSC}}, \code{\link{PloterrCTW}},
  \code{\link{PloterrCWD}}, \code{\link{errCAS}},
  \code{\link{errCLT}}, \code{\link{errCSC}},
  \code{\link{errCTW}}, \code{\link{errCWD}}
}

