% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movav.R
\name{movav}
\alias{movav}
\title{Moving average}
\usage{
movav(X, w)
}
\arguments{
\item{X}{a numeric matrix or vector to process (optionally a data frame that can
be coerced to a numerical matrix).}

\item{w}{filter length.}
}
\value{
a matrix or vector with the filtered signal(s)
}
\description{
A simple moving average of a matrix or vector using a convolution
function written in C++/Rcpp for fast computing
}
\examples{
data(NIRsoil)
wav <- as.numeric(colnames(NIRsoil$spc))
# adding some noise
NIRsoil$spc_noise <- NIRsoil$spc + rnorm(length(NIRsoil$spc), 0, 0.001)
matplot(wav,
  t(NIRsoil$spc_noise[1:10, ]),
  type = "l",
  lty = 1,
  xlab = "Wavelength /nm",
  ylab = "Absorbance",
  col = "grey"
)

# window size of 11 bands
NIRsoil$spc_mov <- movav(NIRsoil$spc_noise, w = 15)
# smoothed data
matlines(as.numeric(colnames(NIRsoil$spc_mov)),
  t(NIRsoil$spc_mov[1:10, ]),
  type = "l",
  lty = 1
)

}
\seealso{
\code{\link{savitzkyGolay}}, \code{\link{gapDer}},
\code{\link{binning}}, \code{\link{continuumRemoval}}
}
\author{
Antoine Stevens
}
