% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_contaminants.R
\name{qc_contaminants}
\alias{qc_contaminants}
\title{Percentage of contaminants per sample}
\usage{
qc_contaminants(
  data,
  sample,
  protein,
  is_contaminant,
  intensity,
  n_contaminants = 5,
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame that contains at least the input variables.}

\item{sample}{a character column in the \code{data} data frame that contains the sample names.}

\item{protein}{a character column in the \code{data} data frame that contains protein IDs or
protein names.}

\item{is_contaminant}{a logical column that indicates if the protein is a contaminant.}

\item{intensity}{a numeric column in the \code{data} data frame that contains the corresponding
raw or normalised intensity values (not log2).}

\item{n_contaminants}{a numeric value that indicates how many contaminants should be displayed
individually. The rest is combined to a group called "other". The default is 5.}

\item{plot}{a logical value that indicates if a plot is returned. If FALSE a table is returned.}

\item{interactive}{a logical value that indicates if the plot is made interactive using the r
package \code{plotly}.}
}
\value{
A bar plot that displays the percentage of contaminating proteins over all samples.
If \code{plot = FALSE} a data frame is returned.
}
\description{
Calculates the percentage of contaminating proteins as the share of total intensity.
}
\examples{
\dontrun{
qc_contaminants(
  data,
  sample = sample,
  protein = leading_razor_protein,
  is_contaminant = potential_contaminant,
  intensity = intensity
)
}
}
