% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{procrustes}
\alias{procrustes}
\title{Generalised Procrustes Analysis (GPA)}
\usage{
procrustes(...)
}
\arguments{
\item{...}{a sequence of datasets of classes \code{DZdata}
and \code{HMdata}}
}
\value{
an object of class \code{GPA}, i.e. a list containing the
following items:

\code{points}: a two column vector with the coordinates of the group configuration

\code{labels}: a list with the sample names
}
\description{
Given a number of input datasets, this function performs an MDS
analysis on each of these and the feeds the resulting
configurations into a GPA algorithm, which uses a combination of
transformations (reflections, rotations, translations and scaling)
to find a 'consensus' configuration which best matches all the
component configurations in a least-squares sense.
}
\examples{
DZ <- read.DZdata(system.file("DZ.csv",package="provenance"))
HM <- read.HMdata(system.file("HM.csv",package="provenance"))
GPA <- procrustes(DZ,HM)
plot(GPA)
}
\author{
Ian L. Dryden
}
\references{
Dryden, Ian, and Maintainer Ian Dryden. "Shapes
package." Vienna, Austria: R Foundation for Statistical Computing
(2012).
}

