% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pscEst_start.R
\name{pscEst_start}
\alias{pscEst_start}
\title{Starting conditions for Bayesian MCMC estimation procedures in 'pscfit'
A procedure which sets the starting conditions for MCMC estimation}
\usage{
pscEst_start(pscOb, nsim, nchain)
}
\arguments{
\item{pscOb}{an pscOb object which has been passed through pscData() and
init() functions}

\item{nsim}{the number of MCMC simulations to run}

\item{nchain}{Number of chains to use for analysis}
}
\value{
An updated set of attributes for the pscOb which includes
}
\description{
Starting conditions for Bayesian MCMC estimation procedures in 'pscfit'
A procedure which sets the starting conditions for MCMC estimation
}
\details{
A procedure which sets the starting conditions for MCMC estimation including
defining starting estimates, setting a matrix for draws to be save in and
defining, target and prior distributions and deifnign the posterior
desitribution from the CFM.  This also sets the number of cores to be used
for estimation where parallel computing is applied.
}
\examples{
e4_data <- psc::e4_data
gemCFM <- psc::gemCFM
pscOb <- pscData(gemCFM,e4_data)
pscOb <- init(pscOb)
pscOb <- pscEst_start(pscOb,nsim=1000,nchain=2)
}
